/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk.pdf.formalePruefungen;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.MeldungPool;
import de.kbv.xpm.modul.ldk.pdf.PDFAllgemeinPruefungen;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10A;
import de.kbv.xpm.modul.ldk.pdf.pruefung.XpmPdfFeld;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public class PDFFormalePruefungen
extends PDFAllgemeinPruefungen {
    private static final String KBV_PDF_006 = "KBV-PDF-006";
    private static final String DATUMREGEX_3103GEBURTSDATUM = "[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}";
    private static final String DATUMREGEX_4110VERSICHERUNGSSCHUTZENDE = "[0-9]{2}\\/[0-9]{2}\\s[0-9]{8}";
    private static final String DATUMREGEX_4102AUSSTELLUNGSDATUM = "[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}";
    private static final String DATUMREGEX_4101AUSSTELLUNGS_JAHR = "[0-9]{2}\\s[0-9]{4}";
    private static final String DATUMREGEX_8219ABNAHMEDATUM = "[0-9]{6}\\s[0-9]{8}";
    private File pdfFile;

    public PDFFormalePruefungen(PDDocument object) {
        this.pdfDocument = object;
        m_MeldungPool = MeldungPool.getInstance();
    }

    public void setPdfFile(File pdfFile) {
        this.pdfFile = pdfFile;
    }

    public void pruefeFormularFelderAufVollstaendigkeit() throws XPMException {
        for (Map.Entry<String, XpmPdfFeld> entry : this.pdfFelder.getAlleFelder().entrySet()) {
            if (entry.getValue().getPdField() == null) {
                if (entry.getValue().getName().equals("0000_QES")) {
                    if (!this.technischeVersion.equals("6")) continue;
                    m_MeldungPool.addMeldung("KBV-PDFLDT-KV-010");
                    continue;
                }
                if (entry.getValue().getName().equals("0000_Behandlung_116b_SGB") && this.technischeVersion.equals("8") || entry.getValue().getName().equals("0000_SER") && this.technischeVersion.equals("7") || entry.getValue().getName().equals("0000_SER") && this.technischeVersion.equals("6")) continue;
                m_MeldungPool.addMeldung("KBV-PDF-1", entry.getValue().getName());
                continue;
            }
            if (!entry.getValue().getName().equals("0000_QES")) continue;
            this.pruefeQes(entry.getValue().getPdField());
        }
    }

    public void pruefeQes(PDField pdFieldQes) throws XPMException {
        if (pdFieldQes != null) {
            try {
                PDSignatureField field = (PDSignatureField)pdFieldQes;
                PDSignature signature = field.getSignature();
                if (signature == null) {
                    m_MeldungPool.addMeldung("KBV-PDFLDT-KV-010");
                }
            }
            catch (Exception ex) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-010");
            }
        }
    }

    public void pruefeSignatur() throws XPMException {
        Boolean signatureExists = false;
        if (this.technischeVersion.equals("8") || this.technischeVersion.equals("7")) {
            try {
                for (PDSignature sig : this.pdfDocument.getSignatureDictionaries()) {
                    String subFilter = sig.getSubFilter();
                    if (subFilter == null || !subFilter.equals("ETSI.CAdES.detached")) continue;
                    signatureExists = true;
                }
            }
            catch (Exception e) {
                logger_.error("Fehler beim Lesen der Signatur:" + e.toString());
            }
            if (!signatureExists.booleanValue()) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-010");
            }
        }
    }

    public void pruefeFormularFelderAufSichtbarkeitUndReadOnly() throws XPMException {
        for (Map.Entry<String, XpmPdfFeld> entry : this.pdfFelder.getAlleFelder().entrySet()) {
            if (entry.getValue() == null || entry.getValue().getPdField() == null) continue;
            PDAnnotationWidget widget = this.getAnnotationWidgetForField(entry.getValue());
            boolean ausgeblendetFlag = widget.isHidden();
            boolean viewFlag = widget.isNoView();
            boolean druckbarFlag = widget.isPrinted();
            boolean readonlyFlag = entry.getValue().getPdField().isReadOnly();
            String feldName = entry.getValue().getName();
            if (ausgeblendetFlag) {
                m_MeldungPool.addMeldung(KBV_PDF_006, feldName);
            } else if (!viewFlag && !druckbarFlag) {
                m_MeldungPool.addMeldung(KBV_PDF_006, feldName);
            } else if (viewFlag && druckbarFlag) {
                m_MeldungPool.addMeldung(KBV_PDF_006, feldName);
            }
            if ("0000_QES".equals(feldName) || readonlyFlag) continue;
            m_MeldungPool.addMeldung("KBV-PDF-007", feldName);
        }
    }

    private PDAnnotationWidget getAnnotationWidgetForField(XpmPdfFeld field) {
        PDTerminalField value = (PDTerminalField)field.getPdField();
        try {
            return value.getWidgets().get(0);
        }
        catch (NullPointerException e) {
            logger_.error("Fehler beim Lesen des Annotationwidgets von Feld:" + field.getName());
            return null;
        }
    }

    public void pruefeFormularFelderDoNotScroll() throws XPMException {
        for (XpmPdfFeld feld : this.pdfFelder.getFelderForNoScrollCheck()) {
            PDTextField tf;
            boolean doNotScroll;
            if (feld.getPdField() == null || (doNotScroll = (tf = (PDTextField)feld.getPdField()).doNotScroll())) continue;
            m_MeldungPool.addMeldung("KBV-PDF-008", feld.getName());
        }
    }

    public void pruefeFormularFelderDatumsfelderMuster10() throws XPMException {
        this.pruefeDatumsFelderGemeinsam();
        PDField pdField = ((FormularfelderMuster10)this.pdfFelder).getAusstellungs_Jahr_4101().getPdField();
        if (pdField != null && !pdField.getValueAsString().isEmpty() && !pdField.getValueAsString().matches(DATUMREGEX_4101AUSSTELLUNGS_JAHR)) {
            m_MeldungPool.addMeldung("KBV-PDF-009", ((FormularfelderMuster10)this.pdfFelder).getAusstellungs_Jahr_4101().getName(), DATUMREGEX_4101AUSSTELLUNGS_JAHR);
        }
    }

    public void pruefeFormularFelderDatumsfelderMuster10A() throws XPMException {
        this.pruefeDatumsFelderGemeinsam();
    }

    private void pruefeDatumsFelderGemeinsam() throws XPMException {
        if (this.pdfFelder.getGeburtsdatum_3103().getPdField() != null && !this.pdfFelder.getGeburtsdatum_3103().getPdField().getValueAsString().isEmpty() && !this.pdfFelder.getGeburtsdatum_3103().getPdField().getValueAsString().matches("[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}")) {
            m_MeldungPool.addMeldung("KBV-PDF-009", this.pdfFelder.getGeburtsdatum_3103().getName(), "[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}");
        }
        if (this.pdfFelder.getVersicherungsschutzEnde_4110().getPdField() != null && !this.pdfFelder.getVersicherungsschutzEnde_4110().getPdField().getValueAsString().isEmpty() && !this.pdfFelder.getVersicherungsschutzEnde_4110().getPdField().getValueAsString().matches(DATUMREGEX_4110VERSICHERUNGSSCHUTZENDE)) {
            m_MeldungPool.addMeldung("KBV-PDF-009", this.pdfFelder.getVersicherungsschutzEnde_4110().getName(), DATUMREGEX_4110VERSICHERUNGSSCHUTZENDE);
        }
        if (this.pdfFelder.getAusstellungsdatum_4102().getPdField() != null && !this.pdfFelder.getAusstellungsdatum_4102().getPdField().getValueAsString().isEmpty() && !this.pdfFelder.getAusstellungsdatum_4102().getPdField().getValueAsString().matches("[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}")) {
            m_MeldungPool.addMeldung("KBV-PDF-009", this.pdfFelder.getAusstellungsdatum_4102().getName(), "[0-9]{2}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{8}");
        }
        if (this.pdfFelder.getAbnahmedatum_8219().getPdField() != null && !this.pdfFelder.getAbnahmedatum_8219().getPdField().getValueAsString().isEmpty() && !this.pdfFelder.getAbnahmedatum_8219().getPdField().getValueAsString().matches(DATUMREGEX_8219ABNAHMEDATUM)) {
            m_MeldungPool.addMeldung("KBV-PDF-009", this.pdfFelder.getAbnahmedatum_8219().getName(), DATUMREGEX_8219ABNAHMEDATUM);
        }
    }

    public void pruefeFormularFelderSchriftGroesseMuster10() throws XPMException {
        this.schriftGroessenPruefungGemeinsam();
        this.checkSchriftgroesse(Arrays.asList(((FormularfelderMuster10)this.pdfFelder).getNummer_0000()), "8");
        this.checkDynamicFontSizeVerdachtsDiagnose(((FormularfelderMuster10)this.pdfFelder).getDiagnose_Verdachtsdiagnose_4207());
        this.checkZeichenZeilenUndSchriftgrFuerFeld4205(((FormularfelderMuster10)this.pdfFelder).getAuftrag_4205());
        this.checkZeichenZeilenUndSchriftgrFuerFeld4208(((FormularfelderMuster10)this.pdfFelder).getBefund_Medikation_4208());
    }

    public void pruefeFormularFelderSchriftGroesseMuster10A() throws XPMException {
        this.schriftGroessenPruefungGemeinsam();
        this.checkDynamicFontSizeSonstigeAuftrag4205(((FormularfelderMuster10A)this.pdfFelder).getAuftrag61_sonstige_Auftraege_4205());
    }

    private void checkDynamicFontSizeSonstigeAuftrag4205(XpmPdfFeld feld) throws XPMException {
        if (feld != null && feld.getPdField() != null) {
            if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 44) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11|12");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 48) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 53) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 59) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 66) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 75) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 87) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() > 87) {
                m_MeldungPool.addMeldung("KBV-PDF-011", feld.getName(), "87", String.valueOf(((PDTextField)feld.getPdField()).getValueAsString().length()));
            }
        }
    }

    private void schriftGroessenPruefungGemeinsam() throws XPMException {
        this.checkSchriftgroesse(this.pdfFelder.getFelderFor12ptSchriftgroessenCheck(), "12");
        this.checkSchriftgroesse(Arrays.asList(this.pdfFelder.getPruefnummer_0000()), "5");
    }

    private void checkZeichenZeilenUndSchriftgrFuerFeld4205(XpmPdfFeld feld) throws XPMException {
        if (feld.getPdField() != null) {
            PDTextField pdTextField = (PDTextField)feld.getPdField();
            String[] lines = this.splitStringForDiffrentLineBreaks(pdTextField);
            String da = pdTextField.getDefaultAppearance();
            String aktFontSize = this.getFontSizeFromDefaultAppearance(da);
            if ("6".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 10, 108);
            } else if ("7".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 8, 92);
            } else if ("8".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 7, 81);
            } else if ("9".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 6, 72);
            } else if ("10".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 6, 65);
            } else if ("11".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 5, 59);
            } else if ("12".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 5, 54);
            } else {
                m_MeldungPool.addMeldung("KBV-PDF-010c", feld.getName(), "12", "6");
            }
        }
    }

    private void checkZeichenZeilenUndSchriftgrFuerFeld4208(XpmPdfFeld feld) throws XPMException {
        if (feld != null && feld.getPdField() != null) {
            PDTextField pdTextField = (PDTextField)feld.getPdField();
            String[] lines = this.splitStringForDiffrentLineBreaks(pdTextField);
            String da = pdTextField.getDefaultAppearance();
            String aktFontSize = this.getFontSizeFromDefaultAppearance(da);
            if ("6".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 6, 108);
            } else if ("7".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 5, 92);
            } else if ("8".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 4, 81);
            } else if ("9".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 4, 72);
            } else if ("10".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 3, 65);
            } else if ("11".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 3, 59);
            } else if ("12".equals(aktFontSize)) {
                this.validateAnzZeichenUndZeilen(feld, lines, aktFontSize, 3, 54);
            } else {
                m_MeldungPool.addMeldung("KBV-PDF-010c", feld.getName(), "12", "6");
            }
        }
    }

    private String[] splitStringForDiffrentLineBreaks(PDTextField pdTextField) {
        String[] lines = pdTextField.getValueAsString().contains("\r") ? pdTextField.getValueAsString().split("\r") : (pdTextField.getValueAsString().contains("\n") ? pdTextField.getValueAsString().split("\n") : new String[]{pdTextField.getValueAsString()});
        return lines;
    }

    private void validateAnzZeichenUndZeilen(XpmPdfFeld feld, String[] lines, String aktSchriftgroesse, int erlaubteZeilen, int erlaubteZeichen) throws XPMException {
        if (lines.length > erlaubteZeilen) {
            m_MeldungPool.addMeldung("KBV-PDF-010b", feld.getName(), String.valueOf(aktSchriftgroesse), String.valueOf(erlaubteZeilen));
        } else {
            for (String line : lines) {
                if (line.length() <= erlaubteZeichen) continue;
                m_MeldungPool.addMeldung("KBV-PDF-011b", feld.getName(), String.valueOf(aktSchriftgroesse), String.valueOf(erlaubteZeichen));
            }
        }
    }

    private void checkDynamicFontSizeDiagnose4207(XpmPdfFeld feld) throws XPMException {
        if (feld != null && feld.getPdField() != null) {
            if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 31) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11|12");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 34) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 37) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 41) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 47) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 53) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6|7");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 62) {
                this.checkSchriftgroesse(Arrays.asList(feld), "6");
            } else if (((PDTextField)feld.getPdField()).getValueAsString().length() > 62) {
                m_MeldungPool.addMeldung("KBV-PDF-011", feld.getName(), "62", String.valueOf(((PDTextField)feld.getPdField()).getValueAsString().length()));
            }
        }
    }

    private void checkDynamicFontSizeVerdachtsDiagnose(XpmPdfFeld feld) throws XPMException {
        if (feld.getPdField() == null) {
            return;
        }
        if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 54) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11|12");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 59) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10|11");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 65) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9|10");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 72) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8|9");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 81) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7|8");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 92) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6|7");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() <= 108) {
            this.checkSchriftgroesse(Arrays.asList(feld), "6");
        } else if (((PDTextField)feld.getPdField()).getValueAsString().length() > 108) {
            m_MeldungPool.addMeldung("KBV-PDF-011", feld.getName(), "108", String.valueOf(((PDTextField)feld.getPdField()).getValueAsString().length()));
        }
    }

    private void checkSchriftgroesse(List<XpmPdfFeld> xpmPdfFeldListe, String erlaubteSchriftgroesse) throws XPMException {
        for (XpmPdfFeld feld : xpmPdfFeldListe) {
            if (feld.getPdField() == null) continue;
            String da = ((PDTextField)feld.getPdField()).getDefaultAppearance();
            String fontSizeFromDefaultAppearance = this.getFontSizeFromDefaultAppearance(da);
            this.checkSchriftgroesseForString(erlaubteSchriftgroesse, feld.getName(), String.valueOf(((PDTextField)feld.getPdField()).getValueAsString().length()), fontSizeFromDefaultAppearance);
        }
    }

    private void checkSchriftgroesseForString(String erlaubteSchriftgroesse, String feldname, String aktSchriftgroesse, String fontSizeFromDefaultAppearance) throws XPMException {
        if (!fontSizeFromDefaultAppearance.matches(erlaubteSchriftgroesse)) {
            m_MeldungPool.addMeldung("KBV-PDF-010", feldname, fontSizeFromDefaultAppearance, "12", aktSchriftgroesse);
        }
    }

    private String getFontSizeFromDefaultAppearance(String defaultAppearance) {
        String[] split;
        String size = "0";
        if (defaultAppearance != null && defaultAppearance.length() != 0 && (split = defaultAppearance.split(" ")).length > 1) {
            size = split[1];
        }
        return size;
    }

    public void pruefeFormularFelderAnzahlZeichen() throws XPMException {
        Map<XpmPdfFeld, Integer> felderMapAufAnzahlZeichen = this.pdfFelder.getFelderMapAufAnzahlZeichen();
        for (Map.Entry<XpmPdfFeld, Integer> entry : felderMapAufAnzahlZeichen.entrySet()) {
            int laenge;
            if (entry.getKey().getPdField() == null || (laenge = entry.getKey().getPdField().getValueAsString().length()) <= entry.getValue()) continue;
            m_MeldungPool.addMeldung("KBV-PDF-011", entry.getKey().getName(), String.valueOf(entry.getValue()), String.valueOf(laenge));
        }
    }
}

