/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Profile;
import de.kbv.xpm.core.pruefung.PluginAdapter;
import de.kbv.xpm.core.pruefung.PruefEventHandler;
import de.kbv.xpm.core.util.XPMStringBuffer;
import de.kbv.xpm.modul.ldk.XPMFehlerListe;
import de.kbv.xpm.modul.ldk.XPMStatistikListe;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;

public class XPMEventHandler
extends PruefEventHandler {
    protected static XPMFehlerListe FehlerListe;
    protected static XPMStatistikListe StatistikListe;
    protected static final int SA_8220 = 0;
    protected static final int SA_8221 = 1;
    protected static final int SA_8230 = 2;
    protected static final int SA_8231 = 3;
    protected static final int SA_8205 = 4;
    protected static final int SA_8215 = 5;
    protected static final int MODUS_BASIS = 0;
    protected static final int MODUS_KBV = 1;
    protected static final int MODUS_QMS = 2;
    protected static final int MODUS_GESAMT = 3;
    protected static final Calendar calendar_;
    protected static final Pattern GNR_PATTERN_EBM2000;
    protected static final Pattern GNR_PATTERN;
    protected static final Pattern FILE_PATTERN;
    protected static final String FEHLER_TEXT = "Die gepr\u00fcfte Datei darf nicht weiterverarbeitet werden.";
    protected static final String OK_TEXT = "Die gepr\u00fcfte Datei kann weiterverarbeitet werden.";
    protected static final String[] aErgebnistext;
    protected static final SimpleDateFormat timeFormat;
    protected static final Date dateJetzt;
    protected static final HashSet<String> setSatzarten;
    protected static final XPMStringBuffer sBuffer_;
    protected static String sSatzart_;
    protected static int nSatzart_;
    protected static int nModus_;
    protected static String sValue_;
    protected static String sValue2_;
    protected static int nValue_;
    protected static StringBuffer sGruppe_;
    protected static final SimpleDateFormat dateFormat;
    protected static Date DATE_01_01_2015;
    protected static Profile m_Profile;

    protected XPMEventHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    protected XPMEventHandler(String sXPath, Profile profile) throws XPMException {
        super(sXPath);
        m_Profile = profile;
        FehlerListe = XPMFehlerListe.getInstance();
        StatistikListe = XPMStatistikListe.getInstance();
    }

    public final void addMeldung(String sMeldungsNr) throws Exception {
        try {
            this.addMeldung(sMeldungsNr, null);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (addMeldung)");
        }
    }

    public final void addMeldung(String sMeldungsNr, String sParameter) throws Exception {
        try {
            boolean add = true;
            switch (nModus_) {
                case 0: {
                    if (!sMeldungsNr.startsWith("QMS") && !sMeldungsNr.startsWith("KBV")) break;
                    add = false;
                    break;
                }
                case 1: {
                    if (!sMeldungsNr.startsWith("QMS")) break;
                    add = false;
                    break;
                }
                case 2: {
                    if (!sMeldungsNr.startsWith("KBV")) break;
                    add = false;
                }
            }
            if (add) {
                m_MeldungPool.addMeldung(sMeldungsNr, sParameter);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (addMeldung)");
        }
    }

    public final void fillStatisticReport() throws XPMException {
        try {
            StatistikListe.addParameter("TITEL", "Fehlerstatistik LDT");
            StatistikListe.addParameter("DATEIEN", m_DatenPool.getString("XPM_FILES"));
            StatistikListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            StatistikListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            StatistikListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            StatistikListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketInformation());
            StatistikListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getRunInfoCounts()));
            StatistikListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getRunWarningCounts()));
            StatistikListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getRunErrorCounts()));
            StatistikListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getRunCancelErrorCounts()));
            String sStatus = String.valueOf(m_MeldungPool.getOkFilesCounts()) + "/" + m_MeldungPool.getWarningFilesCounts() + "/" + m_MeldungPool.getErrorFilesCounts() + "/" + m_MeldungPool.getCancelFilesCounts();
            StatistikListe.addParameter("STATUS", sStatus);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillStatisticReport)");
        }
    }

    public Date getDate(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() > 4) {
                try {
                    return dateFormat.parse(sDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getDate)");
            return null;
        }
    }

    public final int getInt(String sValue, String sFeld) throws Exception {
        try {
            block5: {
                try {
                    if (sValue != null && sValue.length() > 0) {
                        return Integer.parseInt(sValue);
                    }
                }
                catch (NumberFormatException ex) {
                    if (sFeld == null) break block5;
                    m_MeldungPool.addMeldung("BAS-FINT", sValue, sFeld);
                }
            }
            return -1;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getInt)");
            return 0;
        }
    }

    public final String getSatzBezeichnung(int nSatzart) throws Exception {
        try {
            switch (nSatzart) {
                case 0: {
                    return "Labor-Datentr\u00e4ger-Header '8220'";
                }
                case 1: {
                    return "Labor-Datentr\u00e4ger-Abschluss '8221'";
                }
                case 2: {
                    return "Praxis-Datenpaket-Header '8230'";
                }
                case 3: {
                    return "Praxis-Datenpaket-Abschluss '8231'";
                }
                case 4: {
                    return "Satzart Befund 8205";
                }
                case 5: {
                    return "Satzart Auftrag 8215";
                }
            }
            return "";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getSatzBezeichnung)");
            return null;
        }
    }

    public final String getStatus(String sStatus) throws Exception {
        try {
            switch (sStatus.charAt(0)) {
                case '1': {
                    return "M";
                }
                case '3': {
                    return "F";
                }
            }
            return "R";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getStatus)");
            return null;
        }
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="Vorgabe FA")
    public String generateSHA1sum(byte[] convertme) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return this.byteArray2Hex(md.digest(convertme));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (generateSHA1sum)");
            return null;
        }
    }

    public String byteArray2Hex(byte[] hash) throws Exception {
        try {
            Formatter formatter = new Formatter();
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String temp = formatter.toString();
            formatter.close();
            return temp;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (byteArray2Hex)");
            return null;
        }
    }

    public final Date getTime(String sTime) throws Exception {
        try {
            if (sTime != null && sTime.length() > 0) {
                return timeFormat.parse(sTime);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getTime)");
            return null;
        }
    }

    public final void initProtokoll() throws Exception {
        try {
            FehlerListe.addParameter("DATEI", m_DatenPool.getString("XPM_FILE"));
            FehlerListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            FehlerListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            FehlerListe.addParameter("DATEI_DATUM", m_DatenPool.getString("XPM_FILE_DATE"));
            FehlerListe.addParameter("PAKET_VERSION", m_Profile.getPaketVersion());
            FehlerListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            FehlerListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketInformation());
            FehlerListe.addParameter("ERGEBNIS", aErgebnistext[3]);
            FehlerListe.addParameter("ERGEBNIS_TEXT", FEHLER_TEXT);
            FehlerListe.newGroup("Pr\u00fcfprotokoll");
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (initProtokoll)");
        }
    }

    public final void infoPruefModus() throws Exception {
        try {
            switch (nModus_) {
                case 0: {
                    m_MeldungPool.addMeldung("LDT-BASIS");
                    break;
                }
                case 1: {
                    m_MeldungPool.addMeldung("LDT-KBV");
                    break;
                }
                case 2: {
                    m_MeldungPool.addMeldung("LDT-QMS");
                    break;
                }
                case 3: {
                    m_MeldungPool.addMeldung("LDT-GESAMT");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (infoPruefModus)");
        }
    }

    public final void initPruefModus(int nModus) throws Exception {
        try {
            try {
                switch (m_DatenPool.getString("pruef_modus").toLowerCase()) {
                    case "qms": {
                        if (nModus == 2) {
                            nModus_ = 2;
                        }
                        break;
                    }
                    case "kbv": {
                        nModus_ = 1;
                        break;
                    }
                    case "gesamt": {
                        nModus_ = 3;
                        break;
                    }
                    default: {
                        nModus_ = 0;
                        break;
                    }
                }
            }
            catch (Exception ignore) {
                nModus_ = 1;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (initPruefModus)");
        }
    }

    public final int intValue(char c) throws Exception {
        try {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return c - 48;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    return c - 55;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return c - 87;
                }
            }
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (intValue)");
            return 0;
        }
    }

    public final void setSatzart(int nSatzart) throws Exception {
        try {
            nSatzart_ = nSatzart;
            sGruppe_ = FehlerListe.newGroup(this.getSatzBezeichnung(nSatzart));
            sSatzart_ = this.m_Element.getName();
            setSatzarten.add(String.valueOf(nSatzart));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (setSatzart)");
        }
    }

    public final void writeErgebnis() throws Exception {
        try {
            int nReturnCode = Integer.parseInt(m_DatenPool.getString("XPM_RETURN_CODE"));
            FehlerListe.addParameter("ERGEBNIS", aErgebnistext[nReturnCode]);
            if (nReturnCode > 1) {
                FehlerListe.addParameter("ERGEBNIS_TEXT", FEHLER_TEXT);
            } else {
                FehlerListe.addParameter("ERGEBNIS_TEXT", OK_TEXT);
            }
            FehlerListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getInfoCounts()));
            FehlerListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getWarningCounts()));
            FehlerListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getErrorCounts()));
            FehlerListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getCancelErrorCounts()));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (writeErgebnis)");
        }
    }

    public void elementStart() throws XPMException {
        this.init();
        try {
            setSatzarten.clear();
            this.initProtokoll();
            this.initPruefModus(1);
            sValue_ = m_DatenPool.getString("XPM_FILE").toLowerCase();
            if (!FILE_PATTERN.matcher(sValue_).matches()) {
                m_MeldungPool.addMeldung("BAS-FILE", sValue_);
            }
            DATE_01_01_2015 = this.getDate("20150101");
            try {
                Class<?> adapterClass = Class.forName("de.qms.xpm.ldt.QMSAdapter");
                PluginAdapter adapter = (PluginAdapter)adapterClass.newInstance();
                adapter.init();
                this.initPruefModus(2);
                logger_.info("QMS Plugin erfolgreich initialisiert.");
            }
            catch (Exception adapterClass) {}
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            if (setSatzarten.contains(String.valueOf(0)) ^ setSatzarten.contains(String.valueOf(1))) {
                m_MeldungPool.addMeldung("BAS-FSA", this.getSatzBezeichnung(0), this.getSatzBezeichnung(1));
            }
            if (setSatzarten.contains(String.valueOf(2)) ^ setSatzarten.contains(String.valueOf(3))) {
                m_MeldungPool.addMeldung("BAS-FSA", this.getSatzBezeichnung(2), this.getSatzBezeichnung(3));
            }
            if (setSatzarten.contains(String.valueOf(2)) && !setSatzarten.contains(String.valueOf(5))) {
                m_MeldungPool.addMeldung("BAS-FSAP", this.getSatzBezeichnung(2));
            }
            if (setSatzarten.contains(String.valueOf(0)) && !setSatzarten.contains(String.valueOf(4))) {
                m_MeldungPool.addMeldung("BAS-FSAL", this.getSatzBezeichnung(0));
            }
            this.writeErgebnis();
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung");
        }
    }

    public void init() throws XPMException {
        sSatzart_ = "";
        nSatzart_ = 0;
        nModus_ = 0;
        sValue_ = null;
        sValue2_ = null;
        nValue_ = 0;
        sGruppe_ = null;
        DATE_01_01_2015 = null;
    }

    static {
        calendar_ = Calendar.getInstance();
        GNR_PATTERN_EBM2000 = Pattern.compile("[0-9]{5}[A-Z]{0,1}");
        GNR_PATTERN = Pattern.compile("(([A-Z][0-9]{0,4})|([A-Z]{0,1}[0-9]{1,4}))([A-Za-d][A-Z1-4]{0,1}){0,1}(\\/\\d|\\/[A-Z]|\\/#|\\/\\$|\\/\\*|\\/<|\\/>|\\/k){0,1}[A-Z]{0,1}[0-9]{0,1}");
        FILE_PATTERN = Pattern.compile("[z]01[a-z0-9_]{0,249}\\.ldt");
        aErgebnistext = new String[]{"Ok", "Warnung", "Fehlerhaft", "Abbruch"};
        timeFormat = new SimpleDateFormat("HHmm", Locale.GERMAN);
        dateJetzt = Calendar.getInstance().getTime();
        setSatzarten = new HashSet();
        sBuffer_ = new XPMStringBuffer();
        sSatzart_ = "";
        nSatzart_ = 0;
        nModus_ = 0;
        sValue_ = null;
        sValue2_ = null;
        nValue_ = 0;
        sGruppe_ = null;
        dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.GERMAN);
        DATE_01_01_2015 = null;
    }
}

