/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk.pdf.inhaltlichePruefungen;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.MeldungPool;
import de.kbv.xpm.core.util.KV_Bezirksstellen;
import de.kbv.xpm.modul.ldk.pdf.PDFAllgemeinPruefungen;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10A;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

public class PDFInhaltsPruefungen
extends PDFAllgemeinPruefungen {
    protected static final Logger logger_ = LogManager.getLogger(PDFInhaltsPruefungen.class);
    private boolean asvFall;
    private File pdfFile;

    public PDFInhaltsPruefungen(PDDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        m_MeldungPool = MeldungPool.getInstance();
    }

    public void pruefeBsnr() throws XPMException {
        PDField pdFieldBsnr = this.pdfFelder.getBetriebsstaettennummer_0000().getPdField();
        PDField pdFieldWeitereKennz = this.pdfFelder.getWeitere_Kennzeichen_0000().getPdField();
        boolean asvFall = false;
        boolean tssFall = false;
        boolean sapvFall = false;
        if (pdFieldWeitereKennz != null) {
            String kennz = pdFieldWeitereKennz.getValueAsString();
            if ("1".equals(kennz)) {
                asvFall = true;
            } else if ("7".equals(kennz)) {
                tssFall = true;
            }
        }
        if (pdFieldBsnr != null) {
            String bsnr = pdFieldBsnr.getValueAsString();
            String pdfFeldName = this.pdfFelder.getBetriebsstaettennummer_0000().getName();
            if (bsnr.startsWith("74")) {
                sapvFall = true;
            }
            this.checkBsnr(bsnr, pdfFeldName, sapvFall, tssFall, asvFall);
        }
    }

    public final void pruefeAsvTeamNummer(String asvTeamValue, String sFeld) throws XPMException {
        char[] asvTeamNrCharArray = asvTeamValue.toCharArray();
        if (asvTeamNrCharArray[0] != '0' || asvTeamNrCharArray[1] != '0') {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-002", asvTeamValue, sFeld);
            return;
        }
        int summe = 0;
        for (int i = 0; i < asvTeamNrCharArray.length - 1; ++i) {
            int asvTeamNrZiffer = Character.getNumericValue(asvTeamNrCharArray[i]);
            int ergebnisZiffer = 0;
            ergebnisZiffer = i % 2 == 0 ? 4 * asvTeamNrZiffer : 9 * asvTeamNrZiffer;
            summe += ergebnisZiffer;
        }
        int pruefziffer = asvTeamNrCharArray[asvTeamNrCharArray.length - 1] - 48;
        int ermitteltePruefziffer = 10 - summe % 10;
        if (ermitteltePruefziffer == 10) {
            ermitteltePruefziffer = 0;
        }
        if (ermitteltePruefziffer != pruefziffer) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-002", asvTeamValue, sFeld);
        }
    }

    public void pruefeKostentraegerKennung() throws XPMException {
        String kostKennStr;
        PDField kostKenn = this.pdfFelder.getKostentraegerkennung_4111().getPdField();
        if (kostKenn != null && !(kostKennStr = kostKenn.getValueAsString()).matches("\\d{9}")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-013", kostKennStr);
        }
    }

    public void pruefeStatusfeldWB() throws XPMException {
        PDField versArt = this.pdfFelder.getVersichertenart_3108().getPdField();
        PDField besPG = this.pdfFelder.getBesonderePersonengruppe_4131().getPdField();
        PDField dmpKenn = this.pdfFelder.getDmp_Kennzeichnung_4132().getPdField();
        PDField weitereKenn = this.pdfFelder.getWeitere_Kennzeichen_0000().getPdField();
        PDField druckposition29 = this.pdfFelder.getDruckposition29_0000().getPdField();
        String versArtString = null;
        String besPGString = null;
        String dmpKennString = null;
        String weitereKennString = null;
        String druckposition29String = null;
        if (versArt != null) {
            versArtString = versArt.getValueAsString();
        }
        if (besPG != null) {
            besPGString = besPG.getValueAsString();
        }
        if (dmpKenn != null) {
            dmpKennString = dmpKenn.getValueAsString();
        }
        if (weitereKenn != null) {
            weitereKennString = weitereKenn.getValueAsString();
        }
        if (druckposition29 != null) {
            druckposition29String = druckposition29.getValueAsString();
        }
        if (versArtString != null && !versArtString.matches("1|3|5")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-006", this.pdfFelder.getVersichertenart_3108().getName(), versArtString, "1|3|5");
        }
        if (besPGString != null && !besPGString.matches("00|04|06|07|08|09|")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-006", this.pdfFelder.getBesonderePersonengruppe_4131().getName(), besPGString, "00|04|06|07|08|09 oder leer");
        }
        if (dmpKennString != null && !dmpKennString.matches("00|01|02|03|04|05|06|07|08|09|")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-006", this.pdfFelder.getDmp_Kennzeichnung_4132().getName(), dmpKennString, "00|01|02|03|04|05|06|07|08|09 oder leer");
        }
        if (weitereKennString != null && !weitereKennString.isEmpty() && !weitereKennString.matches("0|1|7|")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-006", this.pdfFelder.getWeitere_Kennzeichen_0000().getName(), weitereKennString, "0|1|7 oder leer");
        }
        if (druckposition29String != null && !druckposition29String.isEmpty() && !druckposition29String.matches("0|")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-006", this.pdfFelder.getDruckposition29_0000().getName(), druckposition29String, "0 oder leer");
        }
    }

    public void pruefeBsnrErstveranlasser() throws XPMException {
        String bsnr;
        PDField pdFieldBsnr = ((FormularfelderMuster10)this.pdfFelder).getErstveranlasser_BSNR_0000().getPdField();
        if (pdFieldBsnr != null && !(bsnr = pdFieldBsnr.getValueAsString()).isEmpty()) {
            String pdfFeldName = ((FormularfelderMuster10)this.pdfFelder).getErstveranlasser_BSNR_0000().getName();
            boolean sapvFall = false;
            boolean tssFall = false;
            boolean asvFallLocal = false;
            if (bsnr.startsWith("74")) {
                sapvFall = true;
            }
            if (bsnr.startsWith("35")) {
                tssFall = true;
            }
            if (bsnr.startsWith("00")) {
                asvFallLocal = true;
            }
            this.checkBsnr(bsnr, pdfFeldName, sapvFall, tssFall, asvFallLocal);
        }
    }

    private void checkBsnr(String bsnr, String pdfFeldName, boolean sapvFall, boolean tssFall, boolean asvFallParam) throws XPMException {
        if (bsnr.length() < 9 || !bsnr.matches("\\d{9}")) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-001", bsnr, pdfFeldName);
        } else if (asvFallParam) {
            this.pruefeAsvTeamNummer(bsnr, pdfFeldName);
        } else {
            if (!(!tssFall || bsnr.startsWith("35") && KV_Bezirksstellen.checkIfValueInEnum((String)bsnr.substring(2, 4)))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-004", bsnr, pdfFeldName);
                return;
            }
            if (!(!sapvFall || "63".equals(bsnr.subSequence(7, 9)) && KV_Bezirksstellen.checkIfValueInEnum((String)bsnr.substring(2, 4)))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-014", bsnr, pdfFeldName);
                return;
            }
            if (!(tssFall || sapvFall || KV_Bezirksstellen.checkIfValueInEnum((String)bsnr.substring(0, 2)))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-003", bsnr, pdfFeldName);
            }
        }
    }

    public boolean pruefeLanrPr\u00fcfziffer(String sNr, String sFeld) throws XPMException {
        if (sNr.length() < 7) {
            return false;
        }
        long summe = 0L;
        for (int i = 0; i < 6; ++i) {
            if (i % 2 == 0) {
                summe += (long)(4 * this.intValue(sNr.charAt(i)));
                continue;
            }
            summe += (long)(9 * this.intValue(sNr.charAt(i)));
        }
        if ((summe %= 10L) != 0L) {
            summe = 10L - summe;
        }
        if ((long)this.intValue(sNr.charAt(6)) != summe) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-KV-007", sNr, sFeld);
            return false;
        }
        return true;
    }

    public final int intValue(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 55;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 87;
            }
        }
        return 0;
    }

    public void pruefeLanr() throws XPMException {
        PDField pdFieldLanr = this.pdfFelder.getLebenslangeArztnummer_0000().getPdField();
        if (pdFieldLanr != null && !pdFieldLanr.getValueAsString().isEmpty()) {
            String lanr = pdFieldLanr.getValueAsString();
            String pdfFeldName = this.pdfFelder.getLebenslangeArztnummer_0000().getName();
            if (lanr.length() < 9 || !lanr.matches("\\d{9}")) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-007", lanr, pdfFeldName);
            } else if (!this.asvFall) {
                this.pruefeLanrPr\u00fcfziffer(lanr, pdfFeldName);
            } else if (!lanr.matches("5{6}\\d{3}")) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-008", lanr, pdfFeldName);
            }
        }
    }

    public void pruefeErstveranlasserLanr() throws XPMException {
        String lanr;
        PDField pdFieldLanr = ((FormularfelderMuster10)this.pdfFelder).getErstveranlasser_LANR_0000().getPdField();
        if (pdFieldLanr != null && !(lanr = pdFieldLanr.getValueAsString()).isEmpty()) {
            String pdfFeldName = ((FormularfelderMuster10)this.pdfFelder).getErstveranlasser_LANR_0000().getName();
            boolean asvFallLocal = false;
            if (lanr.matches("5{6}\\d{3}")) {
                asvFallLocal = true;
            }
            if (lanr.length() < 9 || !lanr.matches("\\d{9}")) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-007", lanr, pdfFeldName);
            } else if (!asvFallLocal) {
                this.pruefeLanrPr\u00fcfziffer(lanr, pdfFeldName);
            }
        }
    }

    public void pruefeVersichertenNr() throws XPMException {
        PDField pdFieldVersnr = this.pdfFelder.getVersicherten_ID_3119().getPdField();
        if (pdFieldVersnr != null) {
            String versNr = pdFieldVersnr.getValueAsString();
            String pdfFeldName = this.pdfFelder.getVersicherten_ID_3119().getName();
            if (versNr.length() < 10 || !versNr.matches("[A-Za-z]\\d{9}")) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-009", versNr, pdfFeldName);
            }
        }
    }

    public void pruefe\u00dcbergreifendes() throws XPMException {
        this.pruefeBsnr();
        this.pruefeKostentraegerKennung();
        this.pruefeStatusfeldWB();
        this.pruefeLanr();
        this.pruefeVersichertenNr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="Kann hier nicht passieren da Fehlermeldung vom XPM selbst kommt.")
    private void verifySignature(PDSignature signature) throws FileNotFoundException, IOException, CMSException, CertificateException, StoreException, OperatorCreationException {
        COSDictionary sigDict = signature.getCOSObject();
        COSString contents = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
        byte[] buf = null;
        try (FileInputStream fis = new FileInputStream(this.pdfFile);){
            buf = signature.getSignedContent(fis);
        }
        SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        logger_.debug("Signature found");
        logger_.debug("Name:     " + signature.getName());
        logger_.debug("Modified: " + SDF.format(signature.getSignDate().getTime()));
        String subFilter = signature.getSubFilter();
        if (subFilter != null) {
            switch (subFilter) {
                case "adbe.pkcs7.detached": {
                    this.verifyPKCS7(buf, contents, signature);
                    break;
                }
                case "adbe.pkcs7.sha1": {
                    break;
                }
                case "adbe.x509.rsa_sha1": {
                    break;
                }
                default: {
                    System.err.println("Unknown certificate type: " + subFilter);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="Kann hier nicht passieren da Fehlermeldung vom XPM selbst kommt.")
    private void verifyPKCS7(byte[] byteArray, COSString contents, PDSignature sig) throws CMSException, CertificateException, StoreException, OperatorCreationException {
        CMSProcessableByteArray signedContent = new CMSProcessableByteArray(byteArray);
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)signedContent, contents.getBytes());
        Store<X509CertificateHolder> certificatesStore = signedData.getCertificates();
        Collection<SignerInformation> signers = signedData.getSignerInfos().getSigners();
        SignerInformation signerInformation = signers.iterator().next();
        Collection<X509CertificateHolder> matches = certificatesStore.getMatches(signerInformation.getSID());
        X509CertificateHolder certificateHolder = matches.iterator().next();
        X509Certificate certFromSignedData = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        logger_.debug("certFromSignedData: " + certFromSignedData);
        certFromSignedData.checkValidity(sig.getSignDate().getTime());
        if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().build(certificateHolder))) {
            System.out.println("Signature verified");
        } else {
            System.out.println("Signature verification failed");
        }
    }

    public void pruefeSonstigeAuftraege() throws XPMException {
        PDField pdFieldAuftr61 = ((FormularfelderMuster10A)this.pdfFelder).getAuftrag61_4205().getPdField();
        PDField pdFieldSonstigeAuftr = ((FormularfelderMuster10A)this.pdfFelder).getAuftrag61_sonstige_Auftraege_4205().getPdField();
        if (pdFieldAuftr61 != null && pdFieldSonstigeAuftr != null) {
            PDCheckBox box = (PDCheckBox)pdFieldAuftr61;
            String valSonstigeAuftr = pdFieldSonstigeAuftr.getValueAsString();
            if (box.isChecked() && valSonstigeAuftr.isEmpty()) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-KV-011");
            }
        }
    }

    public void setPdfFile(File pdfFile) {
        this.pdfFile = pdfFile;
    }
}

