/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk.pdf.pruefung;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.AbstractPDFPruefer;
import de.kbv.xpm.core.pruefung.MeldungPool;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.component.ComponentDetails;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.gf.foundry.VeraGreenfieldFoundryProvider;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;

public class PDFPruefer
extends AbstractPDFPruefer {
    protected static final Logger logger = LogManager.getRootLogger();
    protected static MeldungPool m_MeldungPool;
    private PDDocument pdfDocument;
    private File pdfFile;

    public PDFPruefer(String fileStr) throws XPMException {
        m_MeldungPool = MeldungPool.getInstance();
        try {
            this.pdfFile = new File(fileStr);
        }
        catch (NullPointerException e) {
            throw new XPMException((Throwable)e, "Fehler beim Initialisieren des PDF-Lesers.", 51);
        }
    }

    public boolean checkPDFA(PDFAFlavour pdfaFlavour) throws XPMException {
        PDFAParser modelParser;
        PDFAValidator validator;
        logger.info("Initialsiere PDF-Pruefung");
        try {
            this.initVeraGreenfieldFoundry();
            validator = Foundries.defaultInstance().createValidator(pdfaFlavour, false);
            modelParser = this.createModelParserAndSetFieldPdfDocument();
        }
        catch (IOException | EncryptedPdfException | ModelParsingException e) {
            logger.error(e.getMessage() + ": " + e.getCause(), (Throwable)e);
            throw new XPMException("Schwerer Fehler bei der Instanzierung des PDFA-Parsers.");
        }
        ValidationResult result = ValidationResults.defaultResult();
        logger.info("Pruefe PDF auf PDF/A Kompatibilitaet");
        try {
            result = validator.validate(modelParser);
            if (!result.isCompliant()) {
                m_MeldungPool.addMeldung("KBV-PDFA-2");
                validator.close();
                modelParser.close();
                return false;
            }
        }
        catch (IOException | ValidationException e) {
            m_MeldungPool.addMeldung("KBV-PDFA-2");
            try {
                validator.close();
                modelParser.close();
                logger.error("Bei der PDFA Validierung wurde eine Excpetion geworfen: " + e.getMessage());
                return false;
            }
            catch (IOException e1) {
                logger.error("Fehler beim schlie\u00dfen des PDF-Dokuments");
            }
        }
        try {
            validator.close();
            modelParser.close();
        }
        catch (IOException e) {
            logger.error("Fehler beim schlie\u00dfen des PDF-Dokuments");
        }
        return true;
    }

    private PDFAParser createModelParserAndSetFieldPdfDocument() throws ModelParsingException, EncryptedPdfException, IOException, XPMException {
        PDFAParser parser = Foundries.defaultInstance().createParser(this.pdfFile, PDFAFlavour.NO_FLAVOUR);
        this.loadPdfDoc();
        return parser;
    }

    public void loadPdfDoc() throws XPMException {
        try {
            if (this.pdfDocument == null) {
                this.pdfDocument = PDDocument.load(this.pdfFile, MemoryUsageSetting.setupMainMemoryOnly());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new XPMException("Fehler beim Laden des PDFs.");
        }
    }

    private void initVeraGreenfieldFoundry() {
        VeraGreenfieldFoundryProvider.initialise();
        ComponentDetails pdfBoxDetails = null;
        if (pdfBoxDetails == null) {
            pdfBoxDetails = Foundries.defaultInstance().getDetails();
        }
    }

    public PDDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public File getPdfFile() {
        return this.pdfFile;
    }

    public void close() {
        try {
            this.pdfDocument.close();
        }
        catch (IOException e) {
            logger.error("Fehler beim schlie\u00dfen des PDF-Dokuments");
        }
    }
}

