/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.his;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Profile;
import de.kbv.xpm.core.io.AusgabeReport;
import de.kbv.xpm.core.io.ConfigFile;
import de.kbv.xpm.core.pruefung.PruefEventHandler;
import de.kbv.xpm.core.stamm.EhdHeader;
import de.kbv.xpm.modul.dmp.his.XPMFehlerListe;
import de.kbv.xpm.modul.dmp.his.XPMFehlerListeAsatz;
import de.kbv.xpm.modul.dmp.his.XPMStatistikListe;
import de.kbv.xpm.modul.dmp.his.stamm.XPMDMPTabelle;
import de.kbv.xpm.modul.dmp.his.stamm.XPMKTStamm;
import de.kbv.xpm.modul.dmp.his.stamm.XPMPersonenGruppeTabelle;
import de.kbv.xpm.modul.dmp.his.stamm.XPMWOPTabelle;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class XPMEventHandler
extends PruefEventHandler {
    protected static XPMKTStamm KTStamm;
    protected static XPMDMPTabelle DMPTabelle;
    protected static XPMPersonenGruppeTabelle PersonenGruppeTabelle;
    protected static XPMWOPTabelle WOPTabelle;
    protected static AusgabeReport FehlerListe;
    protected static XPMStatistikListe StatistikListe;
    protected static final String m_sDMPModul = "HERZINSUFFIZIENZ";
    protected static boolean m_bFolgeDoku;
    protected static boolean m_bAnlageA;
    protected static final String[] m_Ergebnistext;
    protected static boolean isDateTestDeactivated;
    protected static Profile m_Profile;

    protected XPMEventHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    protected XPMEventHandler(String sXPath, Profile profile) throws XPMException {
        super(sXPath);
        m_Profile = profile;
        KTStamm = XPMKTStamm.getInstance();
        DMPTabelle = XPMDMPTabelle.getInstance();
        PersonenGruppeTabelle = XPMPersonenGruppeTabelle.getInstance();
        WOPTabelle = XPMWOPTabelle.getInstance();
        FehlerListe = m_bAnlageA ? XPMFehlerListeAsatz.getInstance() : XPMFehlerListe.getInstance();
        StatistikListe = XPMStatistikListe.getInstance();
    }

    public final void fillStatisticReport() throws XPMException {
        try {
            StringBuffer sTitel = null;
            if (m_bAnlageA) {
                sTitel = m_bFolgeDoku ? new StringBuffer("Fehlerstatistik Folgedokumentation Dokumentation Herzinsuffizienz (Anlage a)") : new StringBuffer("Fehlerstatistik Erst-Dokumentation Herzinsuffizienz (Anlage a)");
                FehlerListe.addParameter("PAKET_VERSION", (Object)(m_Profile.getPaketVersion() + "  - A-Version"));
            } else {
                sTitel = m_bFolgeDoku ? new StringBuffer("Fehlerstatistik Folgedokumentation Dokumentation Herzinsuffizienz") : new StringBuffer("Fehlerstatistik Erst-Dokumentation Herzinsuffizienz");
                FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            }
            StatistikListe.addParameter("TITEL", sTitel.toString());
            StatistikListe.addParameter("DATEIEN", m_DatenPool.getString("XPM_FILES"));
            StatistikListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            StatistikListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            StatistikListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            StatistikListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketVersion());
            StatistikListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getRunInfoCounts()));
            StatistikListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getRunWarningCounts()));
            StatistikListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getRunErrorCounts()));
            StatistikListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getRunCancelErrorCounts()));
            String sStatus = String.valueOf(m_MeldungPool.getOkFilesCounts()) + "/" + m_MeldungPool.getWarningFilesCounts() + "/" + m_MeldungPool.getErrorFilesCounts() + "/" + m_MeldungPool.getCancelFilesCounts();
            StatistikListe.addParameter("STATUS", sStatus);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillStatisticReport)");
        }
    }

    public void pruefeDokumentTyp(String sDokumentTyp, int nEinschreibegrund) throws Exception {
        try {
            if (sDokumentTyp == null) {
                return;
            }
            if (sDokumentTyp.indexOf("_KHK_") != -1 && !this.testBit(nEinschreibegrund, 1)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_DIABETES1_") != -1 && !this.testBit(nEinschreibegrund, 2)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_DIABETES2_") != -1 && !this.testBit(nEinschreibegrund, 4)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_ASTHMA_") != -1 && !this.testBit(nEinschreibegrund, 8)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_COPD_") != -1 && !this.testBit(nEinschreibegrund, 16)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_HI_") != -1 && !this.testBit(nEinschreibegrund, 64)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_CR_") != -1 && !this.testBit(nEinschreibegrund, 128)) {
                m_MeldungPool.addMeldung("DMP-067");
            } else if (sDokumentTyp.indexOf("_DEPRESSION_") != -1 && !this.testBit(nEinschreibegrund, 256)) {
                m_MeldungPool.addMeldung("DMP-067");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeDokumentTyp)");
        }
    }

    public boolean pruefeXMLSchemaname() throws Exception {
        try {
            boolean bReturn = true;
            ConfigFile config = (ConfigFile)m_DatenPool.getObject("XPM_CONFIG_FILE");
            if (config != null) {
                File schemaXML;
                File schemaConfig = new File(config.getPruefSchema());
                this.m_sValue = this.m_Element.getAttributeValue("noNamespaceSchemaLocation");
                if (this.m_sValue.length() > 0 && !(schemaXML = new File(this.m_sValue)).getName().endsWith(schemaConfig.getName())) {
                    m_MeldungPool.addMeldung("DMP-020", schemaXML.getName(), schemaConfig.getName());
                    bReturn = false;
                }
                this.m_sValue = this.m_Element.getAttributeValue("schemaLocation");
                if (this.m_sValue.length() > 0 && !(schemaXML = new File(this.m_sValue)).getName().endsWith(schemaConfig.getName())) {
                    m_MeldungPool.addMeldung("DMP-020", schemaXML.getName(), schemaConfig.getName());
                    bReturn = false;
                }
            }
            return bReturn;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeXMLSchemaname)");
            return false;
        }
    }

    public String datumNullAnpassung(String sDatum) throws Exception {
        try {
            if (sDatum.length() < 10) {
                return sDatum;
            }
            String sRest = sDatum.substring(10);
            String sYYYY = sDatum.substring(0, 4);
            String sMM = sDatum.substring(5, 7);
            String sDD = sDatum.substring(8, 10);
            if (!(!sYYYY.equals("0000") || sMM.equals("00") && sDD.equals("00"))) {
                return sDatum;
            }
            if (sYYYY.equals("0000")) {
                sYYYY = "1950";
            }
            if (sMM.equals("00")) {
                sMM = "01";
            }
            if (sDD.equals("00")) {
                sDD = "01";
            }
            return sYYYY + "-" + sMM + "-" + sDD + sRest;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (datumNullAnpassung)");
            return null;
        }
    }

    public int getInt(String sValue, String sFeld) throws Exception {
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            try {
                m_MeldungPool.addMeldung("DMP-013", sFeld, sValue);
                return -1;
            }
            catch (Exception ex2) {
                this.catchException(ex2, "XPMEventHandler", "Pr\u00fcfung (getInt)");
                return 0;
            }
        }
    }

    public double getDouble(String sValue, String sFeld) throws Exception {
        try {
            return Double.parseDouble(sValue);
        }
        catch (Exception ex) {
            try {
                m_MeldungPool.addMeldung("DMP-010", sFeld, sValue);
                return -1.0;
            }
            catch (Exception ex2) {
                this.catchException(ex2, "XPMEventHandler", "Pr\u00fcfung (getDouble)");
                return 0.0;
            }
        }
    }

    public String getParameterTyp() throws Exception {
        try {
            String s = this.m_Element.getXPath();
            int i = s.lastIndexOf(47);
            if (i != -1) {
                return s.substring(i + 1);
            }
            return "";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getParameterTyp)");
            return null;
        }
    }

    public int countBits(int iValue) throws Exception {
        try {
            int iCount = 0;
            for (int x = 0; x < 32; ++x) {
                if ((iValue & 1) != 0) {
                    ++iCount;
                }
                iValue >>= 1;
            }
            return iCount;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (countBits)");
            return 0;
        }
    }

    public boolean testBit(int iValue, int iBitNr) throws Exception {
        try {
            return (iValue & iBitNr) == iBitNr;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (testBit)");
            return false;
        }
    }

    public boolean DatumLiegtInZukunft(String sDatum) throws Exception {
        try {
            if (sDatum == null || sDatum.equals("")) {
                return false;
            }
            boolean bReturn = false;
            SimpleDateFormat sdfSciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
            sdfSciphoxFormat.setLenient(true);
            try {
                Date datum = sdfSciphoxFormat.parse(sDatum);
                if (datum.after(Calendar.getInstance().getTime())) {
                    bReturn = true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            sdfSciphoxFormat.setLenient(false);
            return bReturn;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (DatumLiegtInZukunft)");
            return false;
        }
    }

    public int berechneAlter(int iTagGeb, int iMonatGeb, int iJahrGeb, int iTag, int iMonat, int iJahr) throws Exception {
        try {
            int alter = -1;
            alter = iJahr - iJahrGeb;
            if (iMonat < iMonatGeb) {
                --alter;
            } else if (iMonat == iMonatGeb && iTag < iTagGeb) {
                --alter;
            }
            return alter;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (berechneAlter)");
            return 0;
        }
    }

    public String right(String sString, int nAnzahl) throws Exception {
        try {
            return sString.substring(Math.max(0, sString.length() - nAnzahl));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (right)");
            return null;
        }
    }

    public void elementStart() throws XPMException {
        this.init();
        try {
            System.out.println("Start ...");
            String str = m_DatenPool.getString("deactivateDateTest");
            if (str != null && str.equals("true")) {
                isDateTestDeactivated = true;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            EhdHeader header;
            if (m_bAnlageA) {
                if (m_bFolgeDoku) {
                    FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll Folgedokumentation Herzinsuffizienz (Anlage a)");
                } else {
                    FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll Erst-Dokumentation Herzinsuffizienz (Anlage a)");
                }
                FehlerListe.addParameter("PAKET_VERSION", (Object)(m_Profile.getPaketVersion() + "  - A-Version"));
            } else {
                if (m_bFolgeDoku) {
                    FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll Folgedokumentation Herzinsuffizienz");
                } else {
                    FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll Erst-Dokumentation Herzinsuffizienz");
                }
                FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            }
            FehlerListe.addParameter("DATEI", (Object)m_DatenPool.getString("XPM_FILE"));
            FehlerListe.addParameter("DATUM", (Object)m_DatenPool.getString("XPM_DATE"));
            FehlerListe.addParameter("ZEIT", (Object)m_DatenPool.getString("XPM_TIME"));
            FehlerListe.addParameter("DATEI_DATUM", (Object)m_DatenPool.getString("XPM_FILE_DATE"));
            FehlerListe.addParameter("XPM_VERSION", (Object)m_DatenPool.getString("XPM_VERSION"));
            FehlerListe.addParameter("KBV_TAB_VERSION", (Object)m_Profile.getPaketInformation());
            if (KTStamm.isValid() && (header = KTStamm.getHeader()) != null) {
                String sVersion = header.getDokumentTyp() + header.getInterfaceVersion() + "/" + header.getQuartal().toString().replaceFirst("/", "") + "/" + header.getProvider() + "/" + header.getDatum();
                FehlerListe.addParameter("KT_VERSION", (Object)sVersion);
            }
            int nReturnCode = Integer.parseInt(m_DatenPool.getString("XPM_RETURN_CODE"));
            FehlerListe.addParameter("ERGEBNIS_TEXT", (Object)m_Ergebnistext[nReturnCode]);
            FehlerListe.addParameter("RETURN_CODE", (Object)new Integer(nReturnCode));
            FehlerListe.addParameter("INFOS", (Object)String.valueOf(m_MeldungPool.getInfoCounts()));
            FehlerListe.addParameter("WARNUNGEN", (Object)String.valueOf(m_MeldungPool.getWarningCounts()));
            FehlerListe.addParameter("FEHLER", (Object)String.valueOf(m_MeldungPool.getErrorCounts()));
            FehlerListe.addParameter("ABBRUCH", (Object)String.valueOf(m_MeldungPool.getCancelErrorCounts()));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung");
        }
    }

    public void init() throws XPMException {
        isDateTestDeactivated = false;
    }

    public static void setIsAsatz(boolean b) {
        m_bAnlageA = b;
    }

    public static void setIsFolgedoku(boolean b) {
        m_bFolgeDoku = b;
    }

    static {
        m_bFolgeDoku = false;
        m_bAnlageA = false;
        m_Ergebnistext = new String[]{"Ok", "Warnung", "Fehlerhaft", "Abbruch"};
        isDateTestDeactivated = false;
    }
}

