/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.hks;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.io.ConfigFile;
import de.kbv.xpm.core.util.XPMStringBuffer;
import de.kbv.xpm.modul.hks.XPMEventHandler;
import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final int ABSCHNITT_OHNE_NAME = 0;
    protected static final int ABSCHNITT_UEBERWEISUNG = 1;
    protected static final int ABSCHNITT_VERDACHT_DIAGNOSE = 2;
    protected static final int ABSCHNITT_VERDACHT_DIAGNOSE_ARZT = 3;
    protected static final int ABSCHNITT_VERDACHT_DIAGNOSE_DERMATOLOGE = 4;
    protected static final int ABSCHNITT_BIOPSIE_EXZISION = 5;
    protected static final int ABSCHNITT_HISTOPATHOLOGIE = 6;
    protected static final int ABSCHNITT_UNTERSUCHUNG = 7;
    protected static final String OHNE_NAME = "ohne Name";
    protected static final String UEBERWEISUNG = "\u00dcberweisung im Rahmen des Hautkrebs-Screenings";
    protected static final String VERDACHT_DIAGNOSE = "Verdachtsdiagnose";
    protected static final String VERDACHT_DIAGNOSE_ARZT = "Angabe der Verdachtsdiagnose des \u00fcberweisenden Arztes";
    protected static final String VERDACHT_DIAGNOSE_DERMATOLOGE = "Verdachtsdiagnose des Dermatologen";
    protected static final String BIOPSIE_EXZISION = "Biopsie/Exzision";
    protected static final String HISTOPATHOLOGIE = "Histopathologie";
    protected static final String UNTERSUCHUNG = "Gesundheitsuntersuchung";
    protected static String VERDACHTSDIAGNOSEND = "VerdachtsdiagnoseND";
    protected static String MALIGNES_MELANOM = "Malignes Melanom";
    protected static String B_KARZINOM = "Basalzellkarzinom";
    protected static String S_KARZINOM = "Spinozellul\u00e4res Karzinom";
    protected static String ANDERERHAUTKREBS = "anderer Hautkrebs";
    protected static String SONS_DERM_ABKLBED_BEFUND = "sonstiger dermatologisch abkl\u00e4rungsbed\u00fcrftiger Befund";
    protected static String SONS_BIOPSIE_ABKLBED_BEFUND = "sonstiger mit Biopsie abkl\u00e4rungsbed\u00fcrftiger Befund";
    protected static String SCR_TN_AN_DERM_UEBERW = "Screening-Teilnehmer wird an einen Dermatologen \u00fcberwiesen";
    protected static String GGUNTERSUCHUNG = "Gleichzeitig Gesundheitsuntersuchung durchgef\u00fchrt";
    protected static String PATIENT_UEBERWEISUNG = "Patient kommt auf \u00dcberweisung im Rahmen des Hautkrebs-Screenings";
    protected static String UEBW_ARZT_HAT_HKS_DGF = "\u00dcberweisender Arzt hat HKS durchgef\u00fchrt";
    protected static String ANGABE_DIAGNOSE = "Angabe \u00fcber die Verdachtsdiagnose liegt vor";
    protected static String BIOPSIE_ENTNOMMEN = "Biopsie zu Verdachtsdiagnose entnommen oder Exzision durchgef\u00fchrt";
    protected static String ANZ_ENTN_BIOPS_EXZS = "Anzahl der entnommenen Biopsien/Exzisionen";
    protected static String ANDERW_THER_DIAG_VORG_EINGL = "anderweitige Therapie oder Diagnostik vorgenommen bzw. eingeleitet";
    protected static String KEINE_WEITERE_THER_DIAG = "derzeit keine weitere Therapie/Diagnostik";
    protected static String KLASSIFIKATION = "Klassifikation";
    protected static String MELANOM_TUMORDICKE = "Tumordicke (Breslow)";
    protected static String B_KARZINOM_H_DURCHMESSER = "horizontaler Tumordurchmesser (klinisch)";
    protected static String B_KARZINOM_V_DURCHMESSER = "vertikaler Tumordurchmesser (histologisch)";
    protected static String S_KARZINOM_GRADING = "Grading";
    protected static String ATYPISCHER_NAEVUSZELLNAEVUS = "atypischer N\u00e4vuszelln\u00e4vus";
    protected static String JUNKT_COMP_DERM_ATYP_NAEVU = "junktionaler, compound, dermaler atypischer N\u00e4vuszelln\u00e4vus";
    protected static String AKTINISCHE_KERATOSE = "Aktinische Keratose";
    protected static String ANDERE_NICHT_REL_HAUT_VERAE = "Andere hier nicht relevante Hautver\u00e4nderung";
    protected static final String ZIP_DIR = "eHKS/Dokumentation/";
    protected static int nAbschnitt_ = 0;
    protected static Date dateDoku_ = null;
    protected static int nIndikation_ = 0;
    protected static Date dateGeburt_ = null;
    protected static boolean[] aAbschnitte_ = new boolean[8];
    protected static XPMStringBuffer sFileName_ = new XPMStringBuffer();
    protected static int nAlter_ = -1;
    protected static int nVerdachtsdiagnose = 0;
    protected static int nVerdachtsdiagnoseND = 0;
    protected static int nMMelanom_ = 0;
    protected static int nBKarzinom_ = 0;
    protected static int nSKarzinom_ = 0;
    protected static int nAndererHautkrebs = 0;
    protected static int nSons_derm_abklbed_befund = 0;
    protected static int nScrtn_an_derm_ueberw = 0;
    protected static int nGGUntersuchung_ = 0;
    protected static int nUeberweisung_ = 0;
    protected static int nUebw_arzt_hat_hks_dgf = 0;
    protected static int nAngabeDiagnose_ = 0;
    protected static int nMMelanomDermatologe_ = 0;
    protected static int nBKarzinomDermatologe_ = 0;
    protected static int nSKarzinomDermatologe_ = 0;
    protected static int nAndererhautkrebsDerm = 0;
    protected static int nSons_biopsie_abklbed_befundDerm = 0;
    protected static int nBiopsie_ = 0;
    protected static boolean boolAnzBiopsEntVorh = false;
    protected static int nAnzBiopsExz = 0;
    protected static int nAnderwTherDiagVorg = 0;
    protected static int nDerzKeineWeitereTherDiag = 0;
    protected static int nAtypischer_naevuszellnaevus = 0;
    protected static int nJunkt_comp_derm_atyp_naevu = 0;
    protected static int nAktinische_keratose = 0;
    protected static int nAndere_nicht_rel_haut_verae = 0;
    protected static int nAndererhautkrebs_hispa = 0;
    protected static int nAtypischer_naevuszellnaevus_hispa = 0;
    protected static int nJunkt_comp_derm_atyp_naevu_hispa = 0;
    protected static int nAktinische_keratose_hispa = 0;
    protected static int nAndere_nicht_rel_haut_verae_hispa = 0;
    protected static int nMMelanomHisto_ = 0;
    protected static int nMMelanomKlassifikation_ = 0;
    protected static int nMMelanomTumorDicke_ = 0;
    protected static int nBKarzinomHisto_ = 0;
    protected static float fBKarzinomHDurchmesser_ = 0.0f;
    protected static float fBKarzinomVDurchmesser_ = 0.0f;
    protected static int nSKarzinomHisto_ = 0;
    protected static int nSKarzinomKlassifikation_ = 0;
    protected static int nSKarzinomGrading_ = 0;
    protected static String sFirstParameter_ = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
        try {
            sciphoxFormat_.setLenient(false);
            sFileName_.delete();
            ConfigFile config = (ConfigFile)m_DatenPool.getObject("XPM_CONFIG_FILE");
            if (config != null) {
                File schemaXML;
                File schemaConfig = new File(config.getPruefSchema());
                sValue_ = this.m_Element.getAttributeValue("noNamespaceSchemaLocation");
                if (sValue_.length() > 0 && !(schemaXML = new File(sValue_)).getName().toLowerCase().endsWith(schemaConfig.getName().toLowerCase())) {
                    m_MeldungPool.addMeldung("HKS-XMLS", schemaXML.getName(), schemaConfig.getName());
                }
                if ((sValue_ = this.m_Element.getAttributeValue("schemaLocation")).length() > 0 && !(schemaXML = new File(sValue_)).getName().toLowerCase().endsWith(schemaConfig.getName().toLowerCase())) {
                    m_MeldungPool.addMeldung("HKS-XMLS", schemaXML.getName(), schemaConfig.getName());
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Initialisierung");
        }
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            if (dateGeburt_ == null && nAlter_ == -1) {
                m_MeldungPool.addMeldung("HKS-AGE");
            }
            if (nAlter_ != -1 && nAlter_ < 35 && nIndikation_ < 3) {
                m_MeldungPool.addMeldung("HKS-H03a");
            }
            if (bDermatologe_) {
                FehlerListe.newGroup(UEBERWEISUNG);
                this.pruefeJaNein(nUeberweisung_, PATIENT_UEBERWEISUNG, true);
                this.pruefeJaNein(nUebw_arzt_hat_hks_dgf, UEBW_ARZT_HAT_HKS_DGF, true);
                if (nUeberweisung_ == 1) {
                    // empty if block
                }
                m_MeldungPool.reportMeldungen();
                FehlerListe.newGroup(VERDACHT_DIAGNOSE_ARZT);
                this.pruefeJaNein(nAngabeDiagnose_, ANGABE_DIAGNOSE, true);
                this.pruefeJaNein(nMMelanom_, MALIGNES_MELANOM, nAngabeDiagnose_ == 2);
                this.pruefeJaNein(nBKarzinom_, B_KARZINOM, nAngabeDiagnose_ == 2);
                this.pruefeJaNein(nSKarzinom_, S_KARZINOM, nAngabeDiagnose_ == 2);
                this.pruefeJaNein(nAndererHautkrebs, ANDERERHAUTKREBS, nAngabeDiagnose_ == 2);
                if (nAngabeDiagnose_ == 1) {
                    if (nMMelanom_ != 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", ANGABE_DIAGNOSE, "Ja", MALIGNES_MELANOM);
                    }
                    if (nBKarzinom_ != 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", ANGABE_DIAGNOSE, "Ja", B_KARZINOM);
                    }
                    if (nSKarzinom_ != 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", ANGABE_DIAGNOSE, "Ja", S_KARZINOM);
                    }
                    if (nAndererHautkrebs != 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", ANGABE_DIAGNOSE, "Ja", ANDERERHAUTKREBS);
                    }
                }
                m_MeldungPool.reportMeldungen();
                FehlerListe.newGroup(VERDACHT_DIAGNOSE_DERMATOLOGE);
                this.pruefeJaNein(nVerdachtsdiagnose, VERDACHT_DIAGNOSE, true);
                this.pruefeJaNein(nMMelanomDermatologe_, MALIGNES_MELANOM, nVerdachtsdiagnose == 2);
                this.pruefeJaNein(nBKarzinomDermatologe_, B_KARZINOM, nVerdachtsdiagnose == 2);
                this.pruefeJaNein(nSKarzinomDermatologe_, S_KARZINOM, nVerdachtsdiagnose == 2);
                this.pruefeJaNein(nAndererhautkrebsDerm, ANDERERHAUTKREBS, nVerdachtsdiagnose == 2);
                this.pruefeJaNein(nSons_biopsie_abklbed_befundDerm, SONS_BIOPSIE_ABKLBED_BEFUND, nVerdachtsdiagnose == 2);
                m_MeldungPool.reportMeldungen();
                FehlerListe.newGroup(BIOPSIE_EXZISION);
                this.pruefeJaNein(nBiopsie_, BIOPSIE_ENTNOMMEN, true);
                if (nBiopsie_ == 1) {
                    if (nAnzBiopsExz != 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2A", BIOPSIE_ENTNOMMEN, "Nein", ANZ_ENTN_BIOPS_EXZS);
                    }
                } else {
                    if (!boolAnzBiopsEntVorh) {
                        m_MeldungPool.addMeldung("HKS-FEHL", ANZ_ENTN_BIOPS_EXZS);
                    }
                    this.pruefeJaNein(nAnderwTherDiagVorg, ANDERW_THER_DIAG_VORG_EINGL, false);
                }
                this.pruefeJaNein(nAnderwTherDiagVorg, ANDERW_THER_DIAG_VORG_EINGL, true);
                this.pruefeJaNein(nDerzKeineWeitereTherDiag, KEINE_WEITERE_THER_DIAG, true);
                if (nAnderwTherDiagVorg != 1 && nDerzKeineWeitereTherDiag == 2) {
                    m_MeldungPool.addMeldung("HKS-ZUL4", KEINE_WEITERE_THER_DIAG, "Ja", ANDERW_THER_DIAG_VORG_EINGL, "Nein");
                }
                if (nAnderwTherDiagVorg == 2 && nDerzKeineWeitereTherDiag != 1) {
                    m_MeldungPool.addMeldung("HKS-ZUL4", ANDERW_THER_DIAG_VORG_EINGL, "Ja", KEINE_WEITERE_THER_DIAG, "Nein");
                }
                m_MeldungPool.reportMeldungen();
                FehlerListe.newGroup(HISTOPATHOLOGIE);
                if (nBiopsie_ == 2) {
                    this.pruefeJaNein(nMMelanomHisto_, MALIGNES_MELANOM, true);
                    this.pruefeJaNein(nMMelanomKlassifikation_, MALIGNES_MELANOM + "/" + KLASSIFIKATION, nMMelanomHisto_ == 2);
                    this.pruefeWiderspruch(nMMelanomTumorDicke_, MELANOM_TUMORDICKE);
                    if (nMMelanomHisto_ == 1) {
                        if (nMMelanomKlassifikation_ != 0) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", MALIGNES_MELANOM, "Ja", KLASSIFIKATION);
                        }
                        if (nMMelanomTumorDicke_ != 0) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", MALIGNES_MELANOM, "Ja", MELANOM_TUMORDICKE);
                        }
                    }
                    this.pruefeJaNein(nBKarzinomHisto_, B_KARZINOM, true);
                    if (nBKarzinomHisto_ == 1) {
                        if (fBKarzinomHDurchmesser_ != 0.0f) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", B_KARZINOM, "Ja", B_KARZINOM_H_DURCHMESSER);
                        }
                        if (fBKarzinomVDurchmesser_ != 0.0f) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", B_KARZINOM, "Ja", B_KARZINOM_V_DURCHMESSER);
                        }
                    } else if (nBKarzinomHisto_ == 2 && fBKarzinomHDurchmesser_ == 0.0f) {
                        m_MeldungPool.addMeldung("HKS-FEHL", B_KARZINOM_H_DURCHMESSER);
                    }
                    this.pruefeJaNein(nSKarzinomHisto_, S_KARZINOM, true);
                    this.pruefeJaNein(nSKarzinomKlassifikation_, S_KARZINOM + "/" + KLASSIFIKATION, nSKarzinomHisto_ == 2);
                    this.pruefeWiderspruch(nSKarzinomGrading_, S_KARZINOM_GRADING);
                    if (nSKarzinomHisto_ == 1) {
                        if (nSKarzinomKlassifikation_ != 0) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", S_KARZINOM, "Ja", KLASSIFIKATION);
                        }
                        if (nSKarzinomGrading_ != 0) {
                            m_MeldungPool.addMeldung("HKS-ZUL2", S_KARZINOM, "Ja", S_KARZINOM_GRADING);
                        }
                    }
                    this.pruefeJaNein(nAndererhautkrebs_hispa, ANDERERHAUTKREBS, true);
                    this.pruefeJaNein(nAtypischer_naevuszellnaevus_hispa, ATYPISCHER_NAEVUSZELLNAEVUS, true);
                    this.pruefeJaNein(nJunkt_comp_derm_atyp_naevu_hispa, JUNKT_COMP_DERM_ATYP_NAEVU, true);
                    this.pruefeJaNein(nAktinische_keratose_hispa, AKTINISCHE_KERATOSE, true);
                    this.pruefeJaNein(nAndere_nicht_rel_haut_verae_hispa, ANDERE_NICHT_REL_HAUT_VERAE, true);
                } else if (nBiopsie_ == 1) {
                    if (nMMelanomHisto_ > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", MALIGNES_MELANOM);
                    }
                    if (nBKarzinomHisto_ > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", B_KARZINOM);
                    }
                    if (nSKarzinomHisto_ > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", S_KARZINOM);
                    }
                    if (nAndererhautkrebs_hispa > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", ANDERERHAUTKREBS);
                    }
                    if (nAtypischer_naevuszellnaevus_hispa > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", ATYPISCHER_NAEVUSZELLNAEVUS);
                    }
                    if (nJunkt_comp_derm_atyp_naevu_hispa > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", JUNKT_COMP_DERM_ATYP_NAEVU);
                    }
                    if (nAktinische_keratose_hispa > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", AKTINISCHE_KERATOSE);
                    }
                    if (nAndere_nicht_rel_haut_verae_hispa > 0) {
                        m_MeldungPool.addMeldung("HKS-ZUL2", BIOPSIE_ENTNOMMEN, "Ja", ANDERE_NICHT_REL_HAUT_VERAE);
                    }
                }
                m_MeldungPool.reportMeldungen();
            } else {
                FehlerListe.newGroup(VERDACHT_DIAGNOSE);
                this.pruefeJaNein(nVerdachtsdiagnoseND, VERDACHTSDIAGNOSEND, true);
                this.pruefeJaNein(nMMelanom_, MALIGNES_MELANOM, nVerdachtsdiagnoseND == 2);
                this.pruefeJaNein(nBKarzinom_, B_KARZINOM, nVerdachtsdiagnoseND == 2);
                this.pruefeJaNein(nSKarzinom_, S_KARZINOM, nVerdachtsdiagnoseND == 2);
                this.pruefeJaNein(nAndererHautkrebs, ANDERERHAUTKREBS, nVerdachtsdiagnoseND == 2);
                this.pruefeJaNein(nSons_derm_abklbed_befund, SONS_DERM_ABKLBED_BEFUND, nVerdachtsdiagnoseND == 2);
                this.pruefeJaNein(nScrtn_an_derm_ueberw, SCR_TN_AN_DERM_UEBERW, true);
                m_MeldungPool.reportMeldungen();
                FehlerListe.newGroup(UNTERSUCHUNG);
                this.pruefeJaNein(nGGUntersuchung_, GGUNTERSUCHUNG, true);
                m_MeldungPool.reportMeldungen();
            }
            FehlerListe.newGroup("Dateiname");
            sValue_ = m_DatenPool.getString("XPM_FILE").toLowerCase();
            String sNamePattern = sFileName_.toString().toLowerCase();
            if (!Pattern.matches("\\d{9}_" + sNamePattern, sValue_) && sNamePattern.lastIndexOf(95) > 0) {
                switch (nIndikation_) {
                    case 1: {
                        m_MeldungPool.addMeldung("HKS-KONV", sValue_, "HKSD", sNamePattern);
                        break;
                    }
                    case 2: {
                        m_MeldungPool.addMeldung("HKS-KONV", sValue_, "HKSND", sNamePattern);
                        break;
                    }
                    case 4: {
                        m_MeldungPool.addMeldung("HKS-KONV", sValue_, "HKSDEV", sNamePattern);
                        break;
                    }
                    case 8: {
                        m_MeldungPool.addMeldung("HKS-KONV", sValue_, "HKSNDEV", sNamePattern);
                    }
                }
            }
            if ((sValue_ = m_DatenPool.getString("XPM_ZIP_DIR")) != null && !sValue_.equals(ZIP_DIR)) {
                m_MeldungPool.addMeldung("HKS-ZIP", ZIP_DIR);
            }
            m_MeldungPool.reportMeldungen();
            this.fillErrorReport();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        MALIGNES_MELANOM = "Malignes Melanom";
        B_KARZINOM = "Basalzellkarzinom";
        S_KARZINOM = "Spinozellul\u00e4res Karzinom";
        GGUNTERSUCHUNG = "Gleichzeitig Gesundheitsuntersuchung durchgef\u00fchrt";
        PATIENT_UEBERWEISUNG = "Patient kommt auf \u00dcberweisung im Rahmen des Hautkrebs-Screenings";
        ANGABE_DIAGNOSE = "Angabe \u00fcber die Verdachtsdiagnose liegt vor";
        BIOPSIE_ENTNOMMEN = "Biopsie zu Verdachtsdiagnose entnommen oder Exzision durchgef\u00fchrt";
        KLASSIFIKATION = "Klassifikation";
        MELANOM_TUMORDICKE = "Tumordicke (Breslow)";
        B_KARZINOM_H_DURCHMESSER = "horizontaler Tumordurchmesser (klinisch)";
        B_KARZINOM_V_DURCHMESSER = "vertikaler Tumordurchmesser (histologisch)";
        S_KARZINOM_GRADING = "Grading";
        nAbschnitt_ = 0;
        dateDoku_ = null;
        nIndikation_ = 0;
        dateGeburt_ = null;
        aAbschnitte_ = new boolean[8];
        sFileName_ = new XPMStringBuffer();
        nAlter_ = -1;
        nVerdachtsdiagnoseND = 0;
        nVerdachtsdiagnose = 0;
        nMMelanom_ = 0;
        nBKarzinom_ = 0;
        nSKarzinom_ = 0;
        nAndererHautkrebs = 0;
        nSons_derm_abklbed_befund = 0;
        nScrtn_an_derm_ueberw = 0;
        nAnzBiopsExz = 0;
        boolAnzBiopsEntVorh = false;
        nAnderwTherDiagVorg = 0;
        nDerzKeineWeitereTherDiag = 0;
        nAndererhautkrebsDerm = 0;
        nSons_biopsie_abklbed_befundDerm = 0;
        nGGUntersuchung_ = 0;
        nUeberweisung_ = 0;
        nAtypischer_naevuszellnaevus = 0;
        nUebw_arzt_hat_hks_dgf = 0;
        nAngabeDiagnose_ = 0;
        nMMelanomDermatologe_ = 0;
        nBKarzinomDermatologe_ = 0;
        nSKarzinomDermatologe_ = 0;
        nBiopsie_ = 0;
        nMMelanomHisto_ = 0;
        nMMelanomKlassifikation_ = 0;
        nMMelanomTumorDicke_ = 0;
        nBKarzinomHisto_ = 0;
        fBKarzinomHDurchmesser_ = 0.0f;
        fBKarzinomVDurchmesser_ = 0.0f;
        nSKarzinomHisto_ = 0;
        nSKarzinomKlassifikation_ = 0;
        nSKarzinomGrading_ = 0;
        sFirstParameter_ = "";
        nJunkt_comp_derm_atyp_naevu = 0;
        nAktinische_keratose = 0;
        nAndere_nicht_rel_haut_verae = 0;
        nAndererhautkrebs_hispa = 0;
        nAtypischer_naevuszellnaevus_hispa = 0;
        nJunkt_comp_derm_atyp_naevu_hispa = 0;
        nAktinische_keratose_hispa = 0;
        nAndere_nicht_rel_haut_verae_hispa = 0;
    }
}

