/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.stamm.KRW.pruefung.ICD;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.modul.kvdt.common.AbstractScon0Handler;
import de.kbv.xpm.modul.kvdt.common.FallInfo;
import de.kbv.xpm.modul.kvdt.common.GNRInfo;
import de.kbv.xpm.modul.kvdt.common.ScheinInfo;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class Skad0Handler
extends AbstractScon0Handler {
    protected static String f4264 = null;
    protected static boolean b0109Satz_ = false;
    protected static ICD icd_ = null;

    public Skad0Handler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    @Override
    public final void initSatz() throws Exception {
        try {
            super.initSatz();
            m_nSatzart = 9;
            if (m_s0105.length() > 0) {
                m_sGruppe = FehlerListe.newGroup("Kur\u00e4rztliches Datenpaket, Pr\u00fcfnummer: ");
                m_sGruppe.append(m_s0105).append('|');
            } else {
                m_sGruppe = FehlerListe.newGroup("Kur\u00e4rztliches Datenpaket|");
            }
            if (!b0109Satz_) {
                b0109Satz_ = true;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (initSatz)");
        }
    }

    public final void pruefeRegel151(String s4113) throws Exception {
        try {
            if (s4113.length() > 0) {
                switch (s4113.charAt(0)) {
                    case '1': 
                    case '4': 
                    case '9': 
                    case 'A': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'P': 
                    case 'S': 
                    case 'X': {
                        return;
                    }
                }
                m_MeldungPool.addMeldung("KVDT-R151", s4113);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel151)");
        }
    }

    public final void pruefeRegel308() throws Exception {
        block5: {
            try {
                m_sTmp = this.m_Element.getChildValue("f3006");
                if (m_sTmp.length() <= 0) break block5;
                try {
                    int value = Integer.parseInt(m_sTmp.replace(".", ""));
                    if (value < 520) {
                        m_MeldungPool.addMeldung("KVDT-R308");
                    }
                }
                catch (NumberFormatException value) {}
            }
            catch (Exception ex) {
                this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel308)");
            }
        }
    }

    public void pruefeRegel856() throws Exception {
        try {
            if ("Z01.7".equals(icd_.getCode()) && !"G".equals(icd_.getDiagnoseSicherheit())) {
                m_MeldungPool.addMeldung("KVDT-R856", icd_.getCode(), icd_.getDiagnoseSicherheit());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel856)");
        }
    }

    public final void pruefeRegel876() throws Exception {
        try {
            String f4109;
            String f3010 = this.m_Element.findChildValue("s010" + m_nSatzart + "f3010/f3010");
            if (!StringUtils.isEmpty((CharSequence)f3010) && StringUtils.isEmpty((CharSequence)(f4109 = this.m_Element.findChildValue("f4109")))) {
                m_MeldungPool.addMeldung("KVDT-R876");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel876)");
        }
    }

    public void pruefeRegel022() throws Exception {
        try {
            if (!this.pruefeRegel022(icd_.getCode())) {
                m_MeldungPool.addMeldung("KVDT-R022", sValue_, "6001");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel022)");
        }
    }

    public final void pruefeRegel730() throws Exception {
        try {
            if (!m_setBSNr.contains(sValue_) && m_ScheinQuartal.isValid() && !m_AbrQuartal.after(m_ScheinQuartal)) {
                m_MeldungPool.addMeldung("KVDT-R730", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel730)");
        }
    }

    public final void pruefeRegel731() throws Exception {
        try {
            if (!m_setLANr.contains(m_s5099) && !m_s5099.equals("999999900") && m_ScheinQuartal.isValid() && !m_AbrQuartal.after(m_ScheinQuartal)) {
                m_MeldungPool.addMeldung("KVDT-R731");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel731)");
        }
    }

    public final void pruefeRegel537(String f3119) throws Exception {
        try {
            if (f3119.equals("T555558879")) {
                m_MeldungPool.addMeldung("KVDT-R537");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel537)");
        }
    }

    public final void setFehlerGruppe() throws Exception {
        try {
            m_sGruppe.append(m_sName).append(", ").append(m_sVorname).append(", ").append(m_sGeburt).append(", VKNR/KTAB: ").append(m_sVKNR).append('/').append(m_sKTAB).append(", ");
            Date datum = this.getDate(f4264);
            if (datum != null) {
                m_sGruppe.append(m_DateFormat10.format(datum)).append(", ");
            }
            m_sGruppe.append(this.getSatzBezeichnung(m_nSatzart, m_nSU)).append(", Status: ").append(this.getStatus(m_sMFR));
            if (m_s3000 != null) {
                m_sGruppe.append(", Int.: ").append(m_s3000);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (setFehlerGruppe)");
        }
    }

    public final void writeFallStatistik() throws Exception {
        try {
            if (m_mapFallAmbulant.isEmpty()) {
                return;
            }
            this.setReportParameter(KDT_FallListe, "KBV-Pr\u00fcfmodul Fallstatistik (KVDT/KADT, " + cVERSION + "-Version)");
            for (FallInfo fall : m_mapFallAmbulant.values()) {
                String sName;
                SatzKTS kt = KTStamm.getKTSSatz(fall.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion(fall.m_sKTAB)) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                int nSumme = fall.m_nMStatus + fall.m_nFStatus + fall.m_nRStatus;
                m_sBuffer.replace(fall.m_sVKNR);
                m_sBuffer.append('/').append(fall.m_sKTAB);
                KDT_FallListe.addData(m_sBuffer.toString(), sName, new Integer(fall.m_nMStatus), new Integer(fall.m_nFStatus), new Integer(fall.m_nRStatus), new Integer(nSumme), new Integer(fall.m_nVorQuartal), "Ambulant");
            }
            KDT_FallListe.write();
            m_mapFallAmbulant.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (writeFallStatistik)");
        }
    }

    public final void writeGNRStatistik() throws Exception {
        try {
            if (m_mapLANR.isEmpty() || !KDT_GNRListe.getValid()) {
                return;
            }
            progress_.setText("Generiere GNR-Statistikliste...");
            this.setReportParameter(KDT_GNRListe, "KBV-Pr\u00fcfmodul GNR-Statistik (KVDT/KADT, " + cVERSION + "-Version)");
            for (TreeMap map : m_mapLANR.values()) {
                for (GNRInfo m_gnrInfo : map.values()) {
                    int nSumme = Skad0Handler.m_gnrInfo.m_nSatz0101 + Skad0Handler.m_gnrInfo.m_nSatz0102 + Skad0Handler.m_gnrInfo.m_nSatz0103 + Skad0Handler.m_gnrInfo.m_nSatz0104;
                    KDT_GNRListe.addData(Skad0Handler.m_gnrInfo.m_sLANR, Skad0Handler.m_gnrInfo.m_sGNR, new Integer(nSumme), new Integer(nSumme - Skad0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Skad0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Skad0Handler.m_gnrInfo.m_nSatz0101), new Integer(Skad0Handler.m_gnrInfo.m_nSatz0102), new Integer(Skad0Handler.m_gnrInfo.m_nSatz0103), new Integer(Skad0Handler.m_gnrInfo.m_nSatz0104));
                }
            }
            KDT_GNRListe.write();
            m_mapLANR.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (writeGNRStatistik)");
        }
    }

    public final void writeSortierListe() throws Exception {
        try {
            if (m_mapSortierListe.getMap().isEmpty()) {
                return;
            }
            this.setReportParameter(KDT_SortierListe, "KBV-Pr\u00fcfmodul Sortierliste (KVDT/KADT, " + cVERSION + "-Version)");
            String sLastKey = "";
            int nCount = 1;
            int nGroupLength = m_kvx4.getSortKeyGroupLength();
            Iterator iter = m_mapSortierListe.values().iterator();
            while (iter.hasNext()) {
                String sName;
                ScheinInfo scheinInfo = (ScheinInfo)m_mapSortierListe.get((Long)iter.next());
                SatzKTS kt = KTStamm.getKTSSatz(scheinInfo.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion(scheinInfo.m_sKTAB)) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                if (sLastKey.compareTo(scheinInfo.m_sSortKey.substring(0, nGroupLength)) == 0) {
                    scheinInfo.m_nFallNr = ++nCount;
                } else {
                    scheinInfo.m_nFallNr = 1;
                    nCount = 1;
                    sLastKey = scheinInfo.m_sSortKey.substring(0, nGroupLength);
                }
                ++m_nFaelle;
                Integer count = new Integer(scheinInfo.m_nFallNr);
                m_sBuffer.replace(scheinInfo.m_sVKNR);
                KDT_SortierListe.addData(m_sBuffer.append('/').append(scheinInfo.m_sKTAB).toString(), sName, count, scheinInfo.m_sName, scheinInfo.m_sGeburt, scheinInfo.m_sQuartal, scheinInfo.m_sMFR, this.getSatzBezeichnung(scheinInfo.m_nSatzart, scheinInfo.m_nSU), scheinInfo.m_sEinlesetag);
            }
            m_mapSortierListe.close();
            KDT_SortierListe.write();
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (writeSortierListe)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        try {
            this.setDatenpaket(3);
            this.clearListen();
            m_nScheine = 0;
            m_nFaelle = 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            progress_.setText("Generiere KADT Listen...");
            this.writeFallStatistik();
            this.writeGNRStatistik();
            this.writeSortierListe();
            if (!b0109Satz_) {
                m_MeldungPool.addMeldung("KVDT-FSATZ", "KADT", "Kur\u00e4rztliche Behandlung (Satzart 0109)");
            }
            m_nFaelleGesamt += m_nFaelle;
            m_nScheineGesamt += m_nScheine;
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        f4264 = null;
        b0109Satz_ = false;
        icd_ = null;
    }
}

