/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.splitmodul;

import de.kbv.xkm.gui.XKMGUIThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskCopy {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    public static final int DISKCOPY_NOERROR = 0;
    public static final int DISKCOPY_SOURCEDIRERROR = 1;
    public static final int DISKCOPY_SOURCEFILEERROR = 2;
    public static final int DISKCOPY_ANYERROR = 3;
    public static final int DISKCOPY_CANCELED = 5;
    public static final int DISKCOPY_HARDWAREERROR = 7;
    private static final int DISKNOTEMPTY = 1;
    private static final int DISKNOTREADY = 2;
    protected String m_sQuelle;
    protected String m_sZiel;
    protected boolean m_bDeleteOriginal;
    protected long m_nToCopy;
    protected boolean m_bDiskettenpruefung;
    public JFrame parentFrame = null;
    private XKMGUIThread m_XKMGUIThread = null;

    public DiskCopy(String sQuelle, String sZiel, boolean bDeleteOriginal, XKMGUIThread xkmGUIThread, boolean bDiskettenpruefung) {
        this.m_sQuelle = sQuelle;
        this.m_sZiel = sZiel;
        this.m_bDeleteOriginal = bDeleteOriginal;
        this.m_XKMGUIThread = xkmGUIThread;
        this.m_bDiskettenpruefung = bDiskettenpruefung;
        if (sZiel.length() == 2 && sZiel.charAt(1) == ':') {
            this.m_sZiel = this.m_sZiel + "/";
        }
        if (!DiskCopy.isDirectory(this.m_sQuelle) && new File(this.m_sQuelle).isDirectory()) {
            this.m_sQuelle = this.m_sQuelle + "/";
        }
        if (!DiskCopy.isDirectory(this.m_sZiel) && new File(this.m_sZiel).isDirectory()) {
            this.m_sZiel = this.m_sZiel + "/";
        }
    }

    public DiskCopy() {
    }

    public static boolean isDirectory(String sFileOderDir) {
        return sFileOderDir.endsWith("\\") || sFileOderDir.endsWith("/");
    }

    public static boolean copyLoop(BufferedInputStream from, BufferedOutputStream to) {
        int nCopied = 0;
        int nMaxCopy = 256000;
        byte[] arrBytes = new byte[256000];
        try {
            int nBytesRead;
            while ((nBytesRead = from.read(arrBytes, 0, 256000)) != -1) {
                to.write(arrBytes, 0, nBytesRead);
                nCopied += nBytesRead;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canReallyRead(String sName) {
        FileReader fr = null;
        try {
            fr = new FileReader(sName);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int canReallyWrite(String sName, boolean bRealFloppy) {
        File file = null;
        int bReturn = 0;
        try {
            File fFloppy;
            if (bRealFloppy && (fFloppy = new File(new File(sName).getParent())).listFiles().length != 0) {
                return 1;
            }
        }
        catch (Exception e) {
            return 2;
        }
        try {
            file = new File(sName);
            if (!file.createNewFile()) {
                bReturn = 2;
            }
        }
        catch (IOException e) {
            bReturn = 2;
        }
        if (file != null) {
            file.delete();
        }
        return bReturn;
    }

    public int copyFile(String sQuelle, String sZiel, boolean bRealFloppy) {
        BufferedInputStream from;
        int nRetCode = 0;
        try {
            from = new BufferedInputStream(new FileInputStream(sQuelle));
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return 2;
        }
        int nBeschreibbar = this.canReallyWrite(sZiel, bRealFloppy);
        while (nBeschreibbar != 0) {
            if (nBeschreibbar == 1) {
                if (this.m_XKMGUIThread != null) {
                    if (bRealFloppy) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Die Diskette ist nicht leer", "Fehler", 0);
                    } else {
                        JOptionPane.showMessageDialog(this.parentFrame, "Das angegebene Zielverzeichnis ist nicht leer.", "Fehler", 0);
                    }
                } else if (bRealFloppy) {
                    LOG.error("\nDie Diskette ist nicht leer\n");
                } else {
                    LOG.error("\nDas angegebene Zielverzeichnis ist nicht leer.\n");
                }
            } else if (this.m_XKMGUIThread != null) {
                int nChoice = JOptionPane.showConfirmDialog(this.parentFrame, "Bitte pr\u00fcfen Sie, ob die Diskette eingelegt wurde und der Schreibschutz entfernt wurde", "Kein Schreibzugriff auf Laufwerk m\u00f6glich", 2);
                if (nChoice == 2 || nChoice == -1) {
                    return 7;
                }
            } else if (bRealFloppy) {
                LOG.error("Diskette ist nicht beschreibbar!");
                LOG.error("Moegliche Ursachen koennen sein:");
                LOG.error("1) Der mechanische Schreibschutz der Diskette ist aktiviert.");
                LOG.error("2) Die Diskette enthaelt bereits Daten");
                LOG.error("3) Die Diskette ist fehlerhaft.");
            } else {
                LOG.error("Kein Schreibzugriff auf Laufwerk moeglich.");
            }
            LOG.error("<A> fuer Abbrechen, Wiederholen mit <Return>-Taste");
            String s = DiskCopy.getch();
            if (s != null && s.toLowerCase().startsWith("a")) {
                return 7;
            }
            nBeschreibbar = this.canReallyWrite(sZiel, bRealFloppy);
        }
        try {
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(sZiel));
            boolean b = DiskCopy.copyLoop(from, to);
            from.close();
            to.close();
            if (!b) {
                return 7;
            }
        }
        catch (IOException e) {
            if (bRealFloppy) {
                LOG.error("Fehler beim Schreiben auf Diskette.");
            } else {
                LOG.error("Fehler beim Schreiben auf Laufwerk.");
            }
            return 7;
        }
        return nRetCode;
    }

    public static String getch() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String s = in.readLine();
            return s;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(String sQuelldatei, String sZieldatei) {
        FileInputStream from1 = null;
        FileInputStream from2 = null;
        while (!this.canReallyRead(sZieldatei)) {
            if (this.m_XKMGUIThread != null) {
                int nChoice = JOptionPane.showConfirmDialog(this.parentFrame, "Bitte pr\u00fcfen Sie, ob die Diskette eingelegt wurde", "Diskette kann nicht gelesen werden", 2);
                if (nChoice == 2) return false;
                if (nChoice != -1) continue;
                return false;
            }
            LOG.error("Diskette kann nicht gelesen werden.");
            LOG.error("Bitte pruefen Sie, ob die Diskette eingelegt wurde");
            LOG.error("<A> fuer Abbrechen, Wiederholen mit <Return>-Taste");
            String s = DiskCopy.getch();
            if (s == null || !s.toLowerCase().startsWith("a")) continue;
            return false;
        }
        try {
            from1 = new FileInputStream(sQuelldatei);
            from2 = new FileInputStream(sZieldatei);
            int nMaxCopy = 128000;
            byte[] arrBytes1 = new byte[128000];
            byte[] arrBytes2 = new byte[128000];
            if (!new File(sZieldatei).exists()) {
                LOG.error("Fehler bei Disketten-Qualitaetspruefung: Datei auf Diskette nicht gefunden!");
                boolean bl = false;
                return bl;
            }
            block21: while (true) {
                long nBytesRead2;
                long nBytesRead1;
                if ((nBytesRead1 = (long)from1.read(arrBytes1, 0, 128000)) != (nBytesRead2 = (long)from2.read(arrBytes2, 0, 128000))) {
                    LOG.error("Fehler bei Disketten-Qualitaetspruefung: Datei auf Diskette hat nicht die gewuenschte Laenge!");
                    boolean bl = false;
                    return bl;
                }
                if (nBytesRead1 == -1L) {
                    return true;
                }
                int i = 0;
                while (true) {
                    if ((long)i >= nBytesRead1) continue block21;
                    if (arrBytes1[i] != arrBytes2[i]) {
                        LOG.error("Fehler bei Disketten-Qualitaetspruefung: Dateien haben unterschiedliche Inhalte!");
                        boolean bl = false;
                        return bl;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (from1 != null) {
                    from1.close();
                }
                if (from2 != null) {
                    from2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int perform(int nNachlaufzeit) {
        try {
            int i;
            File[] aFiles = null;
            File fQuelle = new File(this.m_sQuelle);
            if (DiskCopy.isDirectory(this.m_sQuelle)) {
                if (!fQuelle.isDirectory()) {
                    LOG.error("Das Verzeichnis " + this.m_sQuelle + " existiert nicht");
                    return 1;
                }
                aFiles = fQuelle.listFiles();
                if (aFiles.length == 0) {
                    LOG.error("Das Verzeichnis " + this.m_sQuelle + " ist leer");
                    return 1;
                }
            } else if (fQuelle.isFile()) {
                aFiles = new File[]{new File(this.m_sQuelle)};
            }
            for (i = 0; i < aFiles.length; ++i) {
                int nRetCode = 0;
                Object sZiel = DiskCopy.isDirectory(this.m_sZiel) ? this.m_sZiel + aFiles[i].getName() : this.m_sZiel;
                Object sQuelle = DiskCopy.isDirectory(this.m_sQuelle) ? this.m_sQuelle + aFiles[i].getName() : this.m_sQuelle;
                this.m_nToCopy = new File((String)sQuelle).length();
                boolean bRealFloppy = false;
                while (true) {
                    File fZiel = new File(this.m_sZiel);
                    Object sMeldung = "Bitte legen Sie eine leere Diskette ins Laufwerk";
                    if (((String)sZiel).startsWith("a:") || ((String)sZiel).startsWith("A:")) {
                        sMeldung = (String)sMeldung + " A:";
                        bRealFloppy = true;
                    }
                    if (((String)sZiel).startsWith("b:") || ((String)sZiel).startsWith("B:")) {
                        sMeldung = (String)sMeldung + " B:";
                        bRealFloppy = true;
                    }
                    if (this.m_XKMGUIThread != null) {
                        String sTitlebarMeldung = "Diskette " + (i + 1) + " von " + aFiles.length + " beschreiben";
                        int nChoice = JOptionPane.showConfirmDialog(this.parentFrame, sMeldung, sTitlebarMeldung, 2);
                        if (nChoice == 2 || nChoice == -1) {
                            return 5;
                        }
                        if ((!fZiel.isDirectory() || fZiel.listFiles().length == 0) && (!fZiel.isFile() || new File(fZiel.getParent()).listFiles().length == 0)) break;
                        if (bRealFloppy) {
                            JOptionPane.showMessageDialog(this.parentFrame, "Die Diskette ist nicht leer", "Fehler", 0);
                            continue;
                        }
                        JOptionPane.showMessageDialog(this.parentFrame, "Das angegebene Zielverzeichnis ist nicht leer.", "Fehler", 0);
                        continue;
                    }
                    LOG.error("\n" + (String)sMeldung);
                    LOG.error("und druecken dann die <Return>-Taste");
                    DiskCopy.getch();
                    if ((!fZiel.isDirectory() || fZiel.listFiles().length == 0) && (!fZiel.isFile() || new File(fZiel.getParent()).listFiles().length == 0)) break;
                    if (bRealFloppy) {
                        LOG.error("\nDie Diskette ist nicht leer\n");
                        continue;
                    }
                    LOG.error("\nDas angegebene Zielverzeichnis ist nicht leer.\n");
                }
                LOG.error("Erstelle Diskette " + (i + 1) + " von " + aFiles.length);
                nRetCode = this.copyFile((String)sQuelle, (String)sZiel, bRealFloppy);
                if (nRetCode != 0) {
                    return nRetCode;
                }
                if (this.m_XKMGUIThread != null && this.m_XKMGUIThread.interruptRequested()) {
                    new File((String)sZiel).delete();
                    return 5;
                }
                Thread.sleep(nNachlaufzeit);
                if (this.m_XKMGUIThread != null && this.m_XKMGUIThread.interruptRequested()) {
                    new File((String)sZiel).delete();
                    return 5;
                }
                if (!this.m_bDiskettenpruefung) continue;
                if (this.m_XKMGUIThread != null) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Achtung - Sehr wichtig! - \nBitte entnehmen Sie die Diskette und\nlegen Sie sie dann wieder ins Laufwerk.\nDanach weiter mit <OK>", "Disketten-Qualit\u00e4tspr\u00fcfung", 1);
                } else {
                    LOG.error("\nAchtung - Sehr wichtig! -\n\nDisketten-Qualitaetspruefung:\nBitte entnehmen Sie die Diskette und\nlegen Sie sie dann wieder ins Laufwerk.\nDanach weiter mit <Return>");
                    DiskCopy.getch();
                }
                boolean bReturn = this.verify((String)sQuelle, (String)sZiel);
                if (this.m_XKMGUIThread != null && this.m_XKMGUIThread.interruptRequested()) {
                    new File((String)sZiel).delete();
                    return 5;
                }
                if (bReturn) continue;
                return 7;
            }
            if (this.m_bDeleteOriginal) {
                for (i = 0; i < aFiles.length; ++i) {
                    aFiles[i].delete();
                }
            }
            return 0;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return 3;
        }
    }
}

