/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import de.kbv.splitmodul.FileConcat;
import de.kbv.splitmodul.FileSplit;
import de.kbv.xkm.Header;
import de.kbv.xkm.Main;
import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.gui.XKMGUIThread;
import de.kbv.xkm.krypto.Crypto;
import de.kbv.xkm.protokoll.Protokoll;
import de.kbv.xkm.utils.Tool;
import de.kbv.xkm.utils.XKMTestschluessel;
import de.kbv.xkm.zip.KbvZipFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Steuerung {
    private String m_sQuellDatei;
    private String m_sZielDatei;
    private int m_nAnzahlPakete;
    private boolean m_bTestmodus;
    private final XKMGUIThread m_XKMGUIThread;
    private Schalter m_Schalter;
    private Arbeitsmodi m_Arbeitsmodi;
    private Protokoll m_Protokoll;
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public Steuerung(XKMGUIThread mainThread) {
        this.m_XKMGUIThread = mainThread;
    }

    public Steuerung() {
        this.m_XKMGUIThread = null;
    }

    private void showInfo(String sMessage) {
        if (this.m_XKMGUIThread == null) {
            Tool.message(true, null, sMessage);
        } else {
            this.m_XKMGUIThread.setStatus(sMessage);
        }
    }

    private void guiCancelCheck() throws XKMException {
        if (this.m_XKMGUIThread != null && this.m_XKMGUIThread.interruptRequested()) {
            throw new XKMException(5, "Verarbeitung durch den Benutzer abgebrochen");
        }
    }

    public int getAnzahlPakete() {
        return this.m_nAnzahlPakete;
    }

    private File[] listFilesSorted(String sDirectory) {
        File[] aFiles = new File(sDirectory).listFiles();
        Arrays.sort(aFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof File && o2 instanceof File) {
                    String name1 = ((File)o1).getName();
                    String name2 = ((File)o2).getName();
                    return name1.compareTo(name2);
                }
                return 0;
            }
        });
        return aFiles;
    }

    public int run(Schalter schalter, Arbeitsmodi arbeitsmodi, Protokoll protokoll) throws XKMException {
        boolean bSomethingDone = false;
        Object sDiskFile = null;
        LOG.debug("Debug-Logging aktiv.");
        this.m_Schalter = schalter;
        this.m_Arbeitsmodi = arbeitsmodi;
        this.m_Protokoll = protokoll;
        this.m_Protokoll.setArbeitsmodus(this.m_Arbeitsmodi.getModusName());
        this.m_Protokoll.setSchluessel(this.m_Schalter.getSchluesseldateiName());
        File[] aFiles = null;
        if (new File(this.m_Schalter.getQuelle()).isFile()) {
            if (!(this.m_Schalter.getQuelle().toLowerCase().endsWith(".xkm.001") && this.m_Arbeitsmodi.istDecryptModus() || this.m_Arbeitsmodi.getSuffix() == null || Tool.endsWithIgnoreCase(this.m_Schalter.getQuelle(), this.m_Arbeitsmodi.getSuffix()))) {
                throw new XKMException(3, "Ungueltige Extension f\u00fcr Datei. Erwartet wird Endung '" + this.m_Arbeitsmodi.getSuffix() + "'");
            }
            aFiles = new File[]{new File(this.m_Schalter.getQuelle())};
        } else {
            aFiles = this.listFilesSorted(this.m_Schalter.getQuelle());
        }
        int nRetCode = 0;
        while (true) {
            this.guiCancelCheck();
            for (int i = 0; aFiles != null && i < aFiles.length; ++i) {
                File file = aFiles[i];
                if (!file.isFile() || this.m_Arbeitsmodi.getSuffix() != null && !Tool.endsWithIgnoreCase(aFiles[i].getName(), this.m_Arbeitsmodi.getSuffix()) && (!Tool.endsWithIgnoreCase(aFiles[i].getName(), this.m_Arbeitsmodi.getStartpaketSuffix()) || !this.m_Arbeitsmodi.istDecryptModus())) continue;
                if (aFiles.length > 1 && this.m_Arbeitsmodi.istDecryptModus()) {
                    Header header = new Header();
                    nRetCode = header.readHeader(file.getAbsolutePath());
                    if (nRetCode != 0) {
                        Tool.FileMove(file.getAbsolutePath(), this.m_Schalter.getAusschusspfad());
                        Tool.message(this.m_XKMGUIThread == null, null, "Datei '" + file.getName() + "' hat kein g\u00fcltiges XKM-Format und wird ins Ausschuss-Verzeichnis verschoben\n");
                        continue;
                    }
                    if (header.getHeaderPaketVon() != 1) continue;
                }
                String sQuellDatei = this.m_sQuellDatei = file.getAbsolutePath();
                if (sDiskFile != null) {
                    this.m_Protokoll.setSource(sDiskFile);
                } else {
                    this.m_Protokoll.setSource(this.m_sQuellDatei);
                }
                sDiskFile = null;
                if (this.m_XKMGUIThread != null && !this.m_Protokoll.protokollErstellbar()) {
                    String sError = "Protokoll kann nicht erstellt werden, Datei ist m\u00f6glicherweise noch ge\u00f6ffnet";
                    JOptionPane.showConfirmDialog(this.m_XKMGUIThread.gui, sError, "Kryptomodul", -1, 0);
                    throw new XKMException(10, sError);
                }
                File f = new File(this.m_Schalter.getZiel() + this.m_Arbeitsmodi.makeNewFilename(new File(this.m_sQuellDatei).getName()));
                this.m_sZielDatei = f.getAbsolutePath();
                this.m_Protokoll.setDestination(this.m_sZielDatei);
                Tool.message(this.m_XKMGUIThread == null, null, "Bearbeite Datei: " + file.getName());
                bSomethingDone = true;
                this.m_nAnzahlPakete = 0;
                this.m_Protokoll.setSplitzaehler(0);
                nRetCode = 0;
                nRetCode = this.m_Arbeitsmodi.istCryptModus() ? this.runEncrypt() : this.runDecrypt();
                this.guiCancelCheck();
                if (nRetCode == 0 && this.m_Schalter.getLoeschModus() && (this.m_Arbeitsmodi.istCryptModus() ? !new File(this.m_sQuellDatei).delete() : (this.m_nAnzahlPakete < 2 ? !new File(this.m_sQuellDatei).delete() : !this.loescheAllePakete(sQuellDatei, this.m_nAnzahlPakete)))) {
                    throw new XKMException(4, "L\u00f6schmodus: Datei " + this.m_Schalter.getQuelle() + "konnte nicht geloescht werden");
                }
                if (nRetCode == 0 && this.m_Schalter.getServerModus() && !this.m_Schalter.getLoeschModus() && this.m_sQuellDatei != null && !this.verschiebeEingangspaket(this.m_sQuellDatei, true)) {
                    throw new XKMException(4, "Fehler beim Verschieben des Eingangspaket");
                }
                if (nRetCode != 0 && !this.m_Schalter.getServerModus() && this.m_Schalter.getLoeschModus() && this.m_sQuellDatei != null && !this.verschiebeEingangspaket(this.m_sQuellDatei, false)) {
                    throw new XKMException(4, "Fehler beim Verschieben des Eingangspaket");
                }
                Main.initVerzeichnisStruktur(this.m_Schalter);
                if (this.m_Schalter.getServerModus()) {
                    if (nRetCode == 0) {
                        Tool.message(this.m_XKMGUIThread == null, null, "Datei '" + file.getName() + "' konnte ohne Probleme verarbeitet werden. Status: 0 - ok\n");
                    } else {
                        Tool.message(this.m_XKMGUIThread == null, null, "Datei '" + file.getName() + "' konnte wegen eines Problems NICHT verarbeitet werden. Status: " + nRetCode + " (" + XKMException.getErrorText(nRetCode) + ")\n");
                    }
                }
                if (!this.m_Schalter.getServerModus()) break;
                this.m_Protokoll.create(nRetCode, "");
            }
            if (this.m_Schalter.getEinzelLaufVerzeichnis() || !this.m_Schalter.getServerModus()) break;
            try {
                Tool.message(this.m_XKMGUIThread == null, null, "Warte auf neue Eingangsdaten.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                throw new XKMException(5, "Der Prueflauf wurde duch den Benutzer abgebrochen.");
            }
            aFiles = new File(this.m_Schalter.getQuelle()).listFiles();
        }
        this.guiCancelCheck();
        if (nRetCode != 0) {
            return nRetCode;
        }
        if (bSomethingDone) {
            return 0;
        }
        return 2;
    }

    private int runEncrypt() throws XKMException {
        int i;
        int nRetCode;
        String sTempDatei = this.m_Schalter.getSystemWorkingDir() + File.separatorChar + this.m_Arbeitsmodi.makeNewFilename(new File(this.m_sQuellDatei).getName());
        String sArztnummer = this.ermittleArztnummer(this.m_sQuellDatei);
        Tool.initDirectory(this.m_Schalter.getSystemWorkingDir());
        if (!Tool.FileCopy(this.m_sQuellDatei, sTempDatei)) {
            throw new XKMException(4, "Fehler beim Erstellen der temporaeren Datei: " + sTempDatei);
        }
        if (this.m_Schalter.getPruefinfo() != null && this.m_Schalter.getArbeitsModusN() == 7 && this.appendKommunikationssatz(sTempDatei, this.m_Schalter.getPruefinfo())) {
            this.m_Protokoll.setPruefinfo(this.m_Schalter.getPruefinfo());
        }
        this.guiCancelCheck();
        if (this.m_Schalter.getAbrechnungsKomprimierung() && (this.m_Schalter.getArbeitsModusN() == 7 || this.m_Schalter.getArbeitsModusN() == 21)) {
            this.showInfo("Komprimiere ...");
            new File(this.m_Schalter.getSystemZipTempVer()).delete();
            if (!Tool.FileMove(sTempDatei, this.m_Schalter.getSystemZipTempVer())) {
                throw new XKMException(4, "Fehler beim Erstellen der temporaeren ZipDatei: " + this.m_Schalter.getSystemZipTempVer());
            }
            this.guiCancelCheck();
            Tool.zipFile(this.m_Schalter.getSystemZipTempVer(), sTempDatei);
            new File(this.m_Schalter.getSystemZipTempVer()).delete();
        }
        this.guiCancelCheck();
        this.showInfo("Verschluessele ...");
        this.runVerschluesselung(sTempDatei);
        if (this.m_Schalter.getPaketgroesseN() > 0L && new File(sTempDatei).length() + 256L > this.m_Schalter.getPaketgroesseN()) {
            long nFilesize = new File(sTempDatei).length();
            long nDateien = nFilesize / (this.m_Schalter.getPaketgroesseN() - 256L);
            if (nFilesize % (this.m_Schalter.getPaketgroesseN() - 256L) != 0L) {
                ++nDateien;
            }
            if (nDateien > 999L) {
                throw new XKMException(3, "Das Programm muesste " + nDateien + " Splitdateien erzeugen, es sind maximal 999 moeglich. Bitte Paketgroesse erhoehen");
            }
            this.m_nAnzahlPakete = (int)nDateien;
            this.showInfo("Splitte ...");
            this.m_Protokoll.setSplitzaehler((int)nDateien);
            FileSplit fileSplit = new FileSplit(sTempDatei, this.m_Schalter.getSystemWorkingDir(), this.m_Schalter.getPaketgroesseN() - 256L, true);
            nRetCode = fileSplit.perform();
            if (nRetCode != 0) {
                throw new XKMException(4, "Problem beim Ausfuehren von FileSplit.perform(). Low-Level-Code: " + nRetCode);
            }
            Tool.message(this.m_XKMGUIThread == null, null, this.getAnzahlPakete() + " Pakete erstellt ...");
        }
        this.guiCancelCheck();
        this.showInfo("Schreibe Header ...");
        File[] aFiles = this.listFilesSorted(this.m_Schalter.getSystemWorkingDir());
        for (i = 0; i < aFiles.length; ++i) {
            Header header = new Header();
            nRetCode = header.createHeader(aFiles[i].getAbsolutePath(), sArztnummer, i + 1, aFiles.length, this.m_Schalter.getArbeitsModusN(), this.m_Schalter.getAbrechnungsKomprimierung() && (this.m_Schalter.getArbeitsModusN() == 7 || this.m_Schalter.getArbeitsModusN() == 21), this.m_Schalter.getPruefinfo() != null && this.m_Schalter.getArbeitsModusN() == 7, this.m_bTestmodus, this.m_Schalter.getSystemDir(), this.m_Schalter.getSchluesseldateiName());
            if (nRetCode == 0) continue;
            throw new XKMException(4, "Fehler beim Erstellen des Headers. " + header.getMessage(nRetCode));
        }
        this.guiCancelCheck();
        aFiles = new File(this.m_Schalter.getSystemWorkingDir()).listFiles();
        for (i = 0; i < aFiles.length; ++i) {
            if (Tool.FileMove(aFiles[i].getAbsolutePath(), this.m_Schalter.getZiel())) continue;
            throw new XKMException(4, "Fehler beim Verschieben der finalen Datei: " + aFiles[i].getAbsolutePath() + ". (Plattenplatz, Zugriffsrechte ?)");
        }
        this.guiCancelCheck();
        return 0;
    }

    private boolean checkAllePaketeVorhanden(String sFirstFilename, int nAnzahlPakete) {
        File fFile = new File(sFirstFilename);
        String sDirectory = fFile.getParent();
        String sFileBasis = fFile.getName().substring(0, fFile.getName().length() - 4);
        for (int i = 2; i <= nAnzahlPakete; ++i) {
            Object sSuffix = "000" + i;
            String sFilename = sDirectory + "/" + sFileBasis + "." + (String)(sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length()));
            if (new File(sFilename).isFile()) continue;
            return false;
        }
        return true;
    }

    private boolean verschiebeAllePakete(String sDirectory, String sDateiname, String sZielVerzeichnis, boolean bBreakOnError) {
        String sFirstFilename;
        File f;
        if (!((String)sDirectory).endsWith("\\") && !((String)sDirectory).endsWith("/")) {
            sDirectory = (String)sDirectory + File.separatorChar;
        }
        if (!(f = new File(sFirstFilename = (String)sDirectory + sDateiname + ".001")).exists()) {
            return false;
        }
        Header header = new Header();
        if (header.readHeader(sFirstFilename) != 0) {
            return false;
        }
        int nAnzahlPakete = header.getHeaderPaketBis();
        if (!Tool.FileMove(sFirstFilename, sZielVerzeichnis)) {
            return false;
        }
        for (int i = 2; i <= nAnzahlPakete; ++i) {
            Object sSuffix = "000" + i;
            if (Tool.FileMove((String)sDirectory + sDateiname + "." + (String)(sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length())), sZielVerzeichnis) || !bBreakOnError) continue;
            return false;
        }
        return true;
    }

    private boolean loescheAllePakete(String sDateiname, int nAnzahlPakete) {
        sDateiname = sDateiname.substring(0, sDateiname.length() - 3);
        for (int i = 1; i <= nAnzahlPakete; ++i) {
            Object sSuffix = "000" + i;
            File f = new File(sDateiname + (String)(sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length())));
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    private String vereinigePakete(String sFilePath, String sZiel) throws XKMException {
        File f = new File(sFilePath);
        Header header = new Header();
        header.readHeader(sFilePath);
        this.m_nAnzahlPakete = header.getHeaderPaketBis();
        this.m_Protokoll.setSplitzaehler(this.m_nAnzahlPakete);
        if (this.m_nAnzahlPakete > 1 && !this.checkAllePaketeVorhanden(sFilePath, this.m_nAnzahlPakete)) {
            if (this.m_Schalter.getServerModus()) {
                String sFilename = new File(sFilePath).getName();
                String sFileBasis = sFilename.substring(0, sFilename.length() - 4);
                this.verschiebeAllePakete(this.m_Schalter.getVerschluesseltpfad(), sFileBasis, this.m_Schalter.getAusschusspfad(), false);
                Tool.message(this.m_XKMGUIThread == null, null, "Folgepaket nicht gefunden");
                return null;
            }
            throw new XKMException(9, "Folgepaket nicht gefunden");
        }
        String sNewName = f.getName().substring(0, f.getName().length() - 4);
        FileConcat fc = new FileConcat(f.getParent(), sNewName, this.m_nAnzahlPakete, sZiel, false, 256L, 0L);
        int nRetCode = fc.perform();
        if (nRetCode != 0) {
            throw new XKMException(4, "Fehler in Klasse FileConcat. Low-Level-Code: " + nRetCode);
        }
        Tool.message(this.m_XKMGUIThread == null, null, this.getAnzahlPakete() + " Pakete vereinigt ...");
        return sNewName;
    }

    private String getTestSchluesselWarnung() {
        String sType = null;
        sType = this.m_Schalter.getArbeitsModusN() == 7 || this.m_Schalter.getArbeitsModusN() == 8 ? "Abrechnungen" : (this.m_Schalter.getArbeitsModusN() == 17 || this.m_Schalter.getArbeitsModusN() == 18 ? "Stammdaten-Verarbeitung" : "Datenlieferungen");
        Object sReturn = "Testschl\u00fcssel-Warnung !\nDie Datei ";
        sReturn = (String)sReturn + (this.m_Arbeitsmodi.istCryptModus() ? "wird" : "wurde");
        sReturn = (String)sReturn + " mit einem Testschl\u00fcssel erstellt\nund darf ausschliesslich zum Testen und NICHT f\u00fcr\nechte ";
        sReturn = (String)sReturn + sType;
        sReturn = (String)sReturn + " verwendet werden!";
        return sReturn;
    }

    private int runDecrypt() throws XKMException {
        String sTempDatei = this.m_Schalter.getSystemWorkingDir() + File.separatorChar;
        if (!Tool.deleteFile(this.m_Schalter.getSystemTempEnt())) {
            throw new XKMException(4, "Bestehende temporaere Datei konnte nicht geloescht werden: " + this.m_Schalter.getSystemTempEnt());
        }
        Header header = new Header();
        int nRetCode = header.readHeader(this.m_sQuellDatei);
        if (nRetCode != 0) {
            throw new XKMException(4, "Fehler beim Lesen des Headers. " + header.getMessage(nRetCode));
        }
        if (header.isTestmodus()) {
            Tool.message(this.m_XKMGUIThread == null, this.m_XKMGUIThread == null ? null : this.m_XKMGUIThread.gui, this.getTestSchluesselWarnung(), 2);
            this.m_Protokoll.setTestmodus();
            this.m_bTestmodus = true;
        }
        if (this.m_sQuellDatei.endsWith(".001")) {
            String sFolgepaket;
            File file;
            if (header.getHeaderPaketBis() == 1 && (file = new File(sFolgepaket = Tool.baseOfFilename(new File(this.m_sQuellDatei).getAbsolutePath()) + ".002")).exists()) {
                return 1;
            }
            sTempDatei = sTempDatei + this.m_Arbeitsmodi.makeNewFilename(new File(this.m_sQuellDatei).getName());
            this.showInfo("Dateien zusammenfuegen ...");
            this.m_sQuellDatei = this.vereinigePakete(this.m_sQuellDatei, this.m_Schalter.getSystemTempEnt());
            if (this.m_sQuellDatei == null) {
                Tool.deleteFile(this.m_Schalter.getSystemTempEnt());
                return 9;
            }
        } else {
            sTempDatei = sTempDatei + this.m_Arbeitsmodi.makeNewFilename(new File(this.m_sQuellDatei).getName());
            this.showInfo("Entferne Header ...");
            Header header2 = new Header();
            nRetCode = header2.cutHeader(this.m_sQuellDatei, this.m_Schalter.getSystemTempEnt());
            if (nRetCode != 0) {
                throw new XKMException(4, "Fehler beim Entfernen des Headers. " + header2.getMessage(nRetCode));
            }
        }
        this.showInfo("Entschluessele ...");
        Crypto crypto = new Crypto();
        nRetCode = crypto.decrypt(this.m_Schalter.getSchluesseldateiName(), this.m_Schalter.getSchluesselBund(), this.m_Schalter.getSystemTempEnt(), sTempDatei);
        this.m_Protokoll.setSchluessel(crypto.getLastusedPrivateKey());
        if (nRetCode != 0) {
            if (this.m_Schalter.getServerModus() && (this.m_nAnzahlPakete > 1 ? !this.verschiebeEingangspaket(this.m_sQuellDatei, false) : new File(this.m_sQuellDatei).exists() && !Tool.FileMove(this.m_sQuellDatei, this.m_Schalter.getAusschusspfad()))) {
                throw new XKMException(4, "Fehler beim Schreiben ins Ausschuss-Verzeichnis: ");
            }
            if (nRetCode == 19) {
                return 11;
            }
            return 6;
        }
        if ("1.31".equals(header.getHeaderXKMVersion().trim())) {
            if (this.m_Schalter.getArbeitsModusN() == 8 || 26 == header.getHeaderArbeitsmodusIndex() + 1) {
                this.unzipFile(sTempDatei);
            } else if (!Tool.FileMove(sTempDatei, this.m_Schalter.getZiel())) {
                throw new XKMException(4, "Fehler beim Verschieben der finalen Datei. (Probleme mit Plattenplatz oder Zugriffsrechten?)");
            }
        } else if (this.m_Schalter.getArbeitsModusN() == 8 || this.m_Schalter.getArbeitsModusN() == 22) {
            this.unzipFile(sTempDatei);
        } else if (!Tool.FileMove(sTempDatei, this.m_Schalter.getZiel())) {
            throw new XKMException(4, "Fehler beim Verschieben der finalen Datei. (Probleme mit Plattenplatz oder Zugriffsrechten?)");
        }
        if (!Tool.deleteFile(this.m_Schalter.getSystemTempEnt())) {
            throw new XKMException(4, "Abgearbeitete temporaere Datei konnte nicht geloescht werden: " + this.m_Schalter.getSystemTempEnt());
        }
        return 0;
    }

    private void unzipFile(String sTempDatei) throws XKMException {
        try {
            KbvZipFile kzf = new KbvZipFile(sTempDatei);
            if (kzf.isZipFile()) {
                this.showInfo("Dekomprimiere ...");
                String sUnzippedFile = this.m_Schalter.getZiel() + new File(sTempDatei).getName();
                if (!Tool.unzipFile(sTempDatei, sUnzippedFile)) {
                    throw new XKMException(4, "Fehler beim Entzippen");
                }
            } else if (!Tool.FileMove(sTempDatei, this.m_Schalter.getZiel())) {
                throw new XKMException(4, "Fehler beim Verschieben der finalen Datei. (Probleme mit Plattenplatz oder Zugriffsrechten?)");
            }
        }
        catch (FileNotFoundException e) {
            throw new XKMException(4, "Fehler beim Entzippen");
        }
    }

    private void runVerschluesselung(String sDataFile) throws XKMException {
        this.m_bTestmodus = false;
        if (XKMTestschluessel.istTestschluessel(this.m_Schalter.getSchluesseldateiName())) {
            Tool.message(this.m_XKMGUIThread == null, this.m_XKMGUIThread == null ? null : this.m_XKMGUIThread.gui, this.getTestSchluesselWarnung(), 2);
            this.m_Protokoll.setTestmodus();
            this.m_bTestmodus = true;
        }
        if (!Tool.deleteFile(this.m_Schalter.getSystemTempVer())) {
            throw new XKMException(4, "Bestehende temporaere Datei konnte nicht geloescht werden: " + this.m_Schalter.getSystemTempVer());
        }
        if (!Tool.FileMove(sDataFile, this.m_Schalter.getSystemTempVer())) {
            throw new XKMException(4, "Temporaere Datei konnte nicht erstellt werden");
        }
        Crypto crypto = new Crypto();
        int nRetCode = crypto.encrypt(this.m_Schalter.getSchluesseldateiName(), this.m_Schalter.getSystemTempVer(), sDataFile);
        if (nRetCode != 0) {
            throw new XKMException(6, "Verschluesselungssproblem in Methode Encrypt(). Low-Level-Code: " + nRetCode);
        }
        if (!Tool.deleteFile(this.m_Schalter.getSystemTempVer())) {
            throw new XKMException(4, "Abgearbeitete temporaere Datei konnte nicht geloescht werden: " + this.m_Schalter.getSystemTempVer());
        }
    }

    private boolean verschiebeEingangspaket(String sDateiname, boolean bErfolgreich) throws XKMException {
        String cDirEntschluesselt;
        String cDirVerschluesselt;
        if (bErfolgreich) {
            cDirVerschluesselt = this.m_Schalter.getBearbeitetVerschluesselung();
            cDirEntschluesselt = this.m_Schalter.getBearbeitetEntschluesselung();
            new File(cDirVerschluesselt).mkdirs();
            new File(cDirEntschluesselt).mkdirs();
        } else {
            cDirVerschluesselt = this.m_Schalter.getAusschusspfad();
            cDirEntschluesselt = this.m_Schalter.getAusschusspfad();
        }
        return !(this.m_Arbeitsmodi.istCryptModus() ? !Tool.FileMove(sDateiname, cDirVerschluesselt) : this.m_Arbeitsmodi.istDecryptModus() && (!new File(sDateiname).exists() ? !this.verschiebeAllePakete(this.m_Schalter.getQuelle(), sDateiname, cDirEntschluesselt, true) : !Tool.FileMove(sDateiname, cDirEntschluesselt)));
    }

    private boolean appendKommunikationssatz(String sZiel, String sKommSatz) throws XKMException {
        RandomAccessFile to = null;
        RandomAccessFile from = null;
        boolean bReturn = false;
        try {
            int nBytesRead;
            int b;
            from = new RandomAccessFile(sKommSatz, "r");
            to = new RandomAccessFile(sZiel, "rw");
            to.seek(to.length());
            int nMaxCopy = 262144;
            byte[] arrChars = new byte[262144];
            do {
                if ((nBytesRead = from.read(arrChars, 0, 11)) != 11) {
                    throw new XKMException(3, "Der Kommunikationssatz muss mit '0138000KOMU' beginnen");
                }
                String sLine = new String(arrChars, 0, 11);
                if (sLine.equalsIgnoreCase("0138000KOMU")) continue;
                throw new XKMException(3, "Der Kommunikationssatz muss mit '0138000KOMU' beginnen");
            } while ((b = from.read()) != 13 && b != 10);
            long lPosition = from.getFilePointer();
            b = from.read();
            if (b != 13 && b != 10) {
                from.seek(lPosition);
            }
            while ((nBytesRead = from.read(arrChars, 0, 262144)) != -1) {
                to.write(arrChars, 0, nBytesRead);
            }
            bReturn = true;
        }
        catch (IOException e) {
            throw new XKMException(3, "Der Kommunikationssatz existiert nicht bzw. konnte nicht angehaengt werden");
        }
        finally {
            try {
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (Exception e) {
                if (this.m_XKMGUIThread == null) {
                    LOG.error("Fehler beim Schliessen eines Datenkanals" + e.getMessage());
                }
                throw new XKMException(3, "Der Kommunikationssatz existiert nicht bzw. konnte nicht angehaengt werden");
            }
        }
        return bReturn;
    }

    private String ermittleArztnummer(String sDatei) throws XKMException {
        Object sArztnummer = "";
        BufferedReader lnr = null;
        if (this.m_Schalter.getArbeitsModusN() == 7) {
            try {
                lnr = new LineNumberReader(new FileReader(sDatei));
                while (((LineNumberReader)lnr).getLineNumber() <= 10) {
                    char c;
                    String line = ((LineNumberReader)lnr).readLine();
                    if (line == null) {
                        break;
                    }
                    if (!line.startsWith("0180201") && !line.startsWith("0160201")) continue;
                    for (int i = 7; i < line.length() && "0123456789".indexOf(c = line.charAt(i)) != -1; ++i) {
                        sArztnummer = (String)sArztnummer + c;
                    }
                }
            }
            catch (Exception e) {
                throw new XKMException(4, "Arztnummer konnte nicht ermittelt werden: " + e.getMessage());
            }
            finally {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_Schalter.getArbeitsModusN() == 3 || this.m_Schalter.getArbeitsModusN() == 5) {
            char c;
            sDatei = new File(sDatei).getName();
            for (int i = 0; i < sDatei.length() && (c = sDatei.charAt(i)) != '_' && c != '.'; ++i) {
                sArztnummer = (String)sArztnummer + c;
            }
        }
        return sArztnummer;
    }
}

