/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.online;

import de.kbv.xkm.gui.XKMGUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XKMOnline {
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    private boolean initializeTempTree(String sTempDir) {
        new File(sTempDir + "/KBV").mkdir();
        String sTemp = sTempDir + "/KBV/XKM/";
        new File(sTemp).mkdir();
        new File(sTemp + "Ausschuss").mkdir();
        new File(sTemp + "Entschluesselt").mkdir();
        new File(sTemp + "Konfig").mkdir();
        new File(sTemp + "Listen").mkdir();
        new File(sTemp + "Quelle").mkdir();
        new File(sTemp + "Schluessel").mkdir();
        new File(sTemp + "Verschluesselt").mkdir();
        sTemp = sTemp + "System/";
        new File(sTemp).mkdir();
        new File(sTemp + "disk").mkdir();
        new File(sTemp + "keys").mkdir();
        new File(sTemp + "work").mkdir();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createConfigFile(String sFilename, String sTempDir) {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new FileOutputStream(sFilename));
            pos.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            pos.println("<Konfiguration>\n");
            pos.println("<quelle>" + sTempDir + "KBV/XKM/Quelle/</quelle>");
            pos.println("<ausschuss>" + sTempDir + "KBV/XKM/Ausschuss/</ausschuss>");
            pos.println("<entschluesselt>" + sTempDir + "KBV/XKM/Entschluesselt/</entschluesselt>");
            pos.println("<verschluesselt>" + sTempDir + "KBV/XKM/Verschluesselt/</verschluesselt>");
            pos.println("<arbeitsmodus>TEST_Verschluesselung</arbeitsmodus>");
            pos.println("<protokolldatei>" + sTempDir + "KBV/XKM/Listen/Protokoll</protokolldatei>");
            pos.println("<system>" + sTempDir + "KBV/XKM/System/</system>");
            pos.println("<schluesselpfad>" + sTempDir + "KBV/XKM/Schluessel/</schluesselpfad>");
            pos.println("<schluesseldatei>" + sTempDir + "KBV/XKM/Konfig/Schluessel.xml</schluesseldatei>");
            pos.println("<protokollformat>PDF</protokollformat>");
            pos.println("<diskette>nein</diskette>");
            pos.println("<paketgroesse>unbegrenzt</paketgroesse>");
            pos.println("<pruefinfo>nein</pruefinfo>");
            pos.println("<konfigdialog>nein</konfigdialog>");
            pos.println("<abrechnungskomprimierung>ja</abrechnungskomprimierung>\n");
            pos.println("</Konfiguration>");
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (pos != null) {
                try {
                    pos.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractResourceFromJar(JarFile jarFile, String sFilenameInJar, String sFilenameOut) {
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            int n;
            JarEntry zipEntry = jarFile.getJarEntry(sFilenameInJar);
            is = jarFile.getInputStream(zipEntry);
            fos = new FileOutputStream(sFilenameOut);
            byte[] b = new byte[10240];
            while ((n = is.read(b)) > 0) {
                fos.write(b, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void main(String[] args) {
        String sTempDir;
        XKMOnline xkmOnline;
        LOG.info("Online-Vorschaltmodul: Programm gestartet");
        String sVersion = System.getProperty("java.version");
        LOG.info(sVersion);
        if (sVersion.equals("1.6.0_14") || sVersion.equals("1.6.0_15") || sVersion.equals("1.6.0_16")) {
            LOG.info("Geht nicht wegen Bug in Sun bzgl. Bouncycastle");
        }
        if (!(xkmOnline = new XKMOnline()).initializeTempTree(sTempDir = System.getProperty("java.io.tmpdir"))) {
            LOG.error("Temporaerer Verzeichnis-Baum konnte nicht erstellt werden");
        }
        try {
            JarFile jarFile = new JarFile("xkmonline.jar");
            xkmOnline.extractResourceFromJar(jarFile, "schluessel.xml", sTempDir + "/KBV/XKM/Konfig/schluessel.xml");
            xkmOnline.extractResourceFromJar(jarFile, "schluesselintern.xml", sTempDir + "/KBV/XKM/System/schluesselintern.xml");
            xkmOnline.extractResourceFromJar(jarFile, "XKMProtokoll.jasper", sTempDir + "/KBV/XKM/System/XKMProtokoll.jasper");
            xkmOnline.extractResourceFromJar(jarFile, "Oeffentlich_Testschluessel_V01.pub", sTempDir + "/KBV/XKM/System/keys/Oeffentlich_Testschluessel_V01.pub");
        }
        catch (IOException e) {
            LOG.error("Online-Vorschaltmodul: Fehler beim Verarbeiten der Resourcen-Jar");
            e.printStackTrace();
        }
        if (!xkmOnline.createConfigFile(sTempDir + "/KBV/XKM/Konfig/config.xml", sTempDir)) {
            LOG.error("Online-Vorschaltmodul: Konfigurationsdatei konnte nicht erstellt werden");
        }
        args = new String[]{"-cC:/Dokumente und Einstellungen/rstahlberg/Lokale Einstellungen/Temp/KBV/XKM/Konfig/config.xml"};
        XKMGUI xkmgui = new XKMGUI(args);
        LOG.info("Online-Vorschaltmodul: Programm beendet");
    }
}

