/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.protokoll;

import de.kbv.xkm.Main;
import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.protokoll.AusgabeFormat;
import de.kbv.xkm.utils.Tool;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Protokoll {
    static final String sUeberschrift = "Ver-/Entschl\u00fcsselungsprotokoll Kryptomodul (XKM)";
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    private JasperReport m_jasperReport;
    private JasperPrint m_jasperPrint;
    private String m_sQuellDatei;
    private String m_sZielDatei;
    private String m_sSchluessel;
    private String m_sArbeitsmodus;
    private String m_sException;
    private int m_nSplitZaehler;
    private String m_sPruefinfo;
    private boolean m_bTestModus;
    private final Schalter m_Schalter;
    private final Arbeitsmodi m_Arbeitsmodi;

    public Protokoll(Schalter schalter, Arbeitsmodi arbeitsmodi) {
        this.m_Schalter = schalter;
        this.m_Arbeitsmodi = arbeitsmodi;
    }

    private String getVerb() {
        if (this.m_sArbeitsmodus != null) {
            return this.m_Arbeitsmodi.istCryptModus() ? "verschl\u00fcsselt" : "entschl\u00fcsselt";
        }
        return "ver- oder entschl\u00fcsselt";
    }

    private String getNomen() {
        if (this.m_sArbeitsmodus != null) {
            return this.m_Arbeitsmodi.istCryptModus() ? "Verschl\u00fcsselung" : "Entschl\u00fcsselung";
        }
        return "Ver- oder Entschl\u00fcsselung";
    }

    public void setSource(String sQuellDatei) {
        this.m_sQuellDatei = sQuellDatei;
    }

    public void setDestination(String sZielDatei) {
        this.m_sZielDatei = sZielDatei;
    }

    public String getDestination() {
        return this.m_sZielDatei;
    }

    public void setSchluessel(String sSchluessel) {
        this.m_sSchluessel = sSchluessel;
    }

    public void setArbeitsmodus(String sArbeitsmodus) {
        this.m_sArbeitsmodus = sArbeitsmodus;
    }

    public Arbeitsmodi getArbeitsmodus() {
        return this.m_Arbeitsmodi;
    }

    public void setPruefinfo(String sPruefinfo) {
        this.m_sPruefinfo = sPruefinfo;
    }

    public void setException(String sException) {
        this.m_sException = sException;
    }

    public void setSplitzaehler(int nSplitzaehler) {
        this.m_nSplitZaehler = nSplitzaehler;
    }

    public int getSplitzaehler() {
        return this.m_nSplitZaehler;
    }

    public void setTestmodus() {
        this.m_bTestModus = true;
    }

    private String addSuffix(String sFilename, int nMode) {
        String sSoll = AusgabeFormat.getInstance().getDateiEndung(nMode);
        if (!((String)sFilename).toLowerCase().endsWith(sSoll)) {
            sFilename = (String)sFilename + sSoll;
        }
        return sFilename;
    }

    public boolean protokollErstellbar() {
        ArrayList arrayList = AusgabeFormat.getInstance().getAktiveFormate();
        for (int i = 0; i < arrayList.size(); ++i) {
            int nFormat = (Integer)arrayList.get(i);
            String sProtokollname = this.buildProtokollname(nFormat);
            File file = new File(sProtokollname);
            if (!file.exists() || file.delete()) continue;
            return false;
        }
        return true;
    }

    private String buildProtokollname(int nFormat) {
        Object sFilename;
        if (this.m_Schalter.getProtokollDatei() != null) {
            sFilename = this.m_Schalter.getProtokollDatei();
            if (((String)sFilename).endsWith("\\") || ((String)sFilename).endsWith("/")) {
                sFilename = (String)sFilename + "Protokoll";
            }
        } else {
            sFilename = "Protokoll";
        }
        if (this.m_Schalter.getServerModus()) {
            if ((sFilename = new File((String)sFilename).getParent()) == null) {
                sFilename = "./";
            }
            if (!Tool.isDirectory((String)sFilename)) {
                sFilename = (String)sFilename + "/";
            }
            sFilename = this.m_sQuellDatei != null ? (String)sFilename + new File(this.m_sQuellDatei).getName() + "_Protokoll" : (String)sFilename + "Protokoll";
        }
        return this.addSuffix((String)sFilename, nFormat);
    }

    private String getTextAnzahlPakete(int nErrorCode) {
        Object sAnzahlPakete;
        if (nErrorCode != 0) {
            sAnzahlPakete = "-";
        } else if (this.m_nSplitZaehler > 1) {
            sAnzahlPakete = new Integer(this.m_nSplitZaehler).toString();
            sAnzahlPakete = this.m_Arbeitsmodi.istCryptModus() ? (String)sAnzahlPakete + " Pakete erstellt" : (String)sAnzahlPakete + " Pakete vereinigt";
        } else {
            sAnzahlPakete = "1";
        }
        return sAnzahlPakete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTxt(String sFilename, String sTitel, String sQuelldatei, String sZieldatei, String sPruefinfo, String sArbeitsmodus, String sSchluessel, String sVersion, String sEndstatus1, String sEndstatus2, String sException, int nErrorCode) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(sFilename);
            fw.write("\r\n" + sTitel + "\r\n\r\n\r\n");
            fw.write("Dateiname der Quelle:        " + sQuelldatei + "\r\n\r\n");
            fw.write("Dateiname der Zieldatei:     " + sZieldatei + "\r\n\r\n");
            fw.write(this.getNomen() + "sdatum:       " + Tool.getToday() + "\r\n\r\n");
            fw.write(this.getNomen() + "suhrzeit:     " + Tool.getNow() + "\r\n\r\n");
            fw.write("Anzahl Pakete:               " + this.getTextAnzahlPakete(nErrorCode) + "\r\n\r\n");
            if (sPruefinfo != null) {
                fw.write("Kommunikationssatz:          " + sPruefinfo + "\r\n\r\n");
            }
            fw.write("Arbeitsmodus:                " + sArbeitsmodus + "\r\n\r\n");
            fw.write("Verwendeter Schl\u00fcssel:       " + sSchluessel + "\r\n\r\n");
            fw.write("Verwendete XKM-Version       " + sVersion + "\r\n\r\n\r\n\r\n");
            fw.write(sEndstatus1 + "\r\n\r\n\r\n");
            fw.write(sEndstatus2);
            if (sException != null && sException.length() > 0) {
                fw.write("\r\n\r\n---\r\n\r\nException-Text: " + sException);
            }
            fw.write("\r\n\r\n\f");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeFormat(int nFormat, String sFilename, String sTitel, String sQuelldatei, String sZieldatei, String sPruefinfo, String sArbeitsmodus, String sSchluessel, String sVersion, String sEndstatus1, String sEndstatus2, int nErrorCode, String sException) {
        if (nErrorCode != 0) {
            String sAnzahlPakete = "-";
        } else if (this.m_nSplitZaehler > 1) {
            Object sAnzahlPakete = new Integer(this.m_nSplitZaehler).toString();
            sAnzahlPakete = this.m_Arbeitsmodi.istCryptModus() ? (String)sAnzahlPakete + " Pakete erstellt" : (String)sAnzahlPakete + " Pakete vereinigt";
        } else {
            String sAnzahlPakete = "1";
        }
        String sJavaVersionWarnung = this.getJavaversionWarnung();
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("JAVAVERSIONWARNUNG", sJavaVersionWarnung);
        mapParams.put("TITEL", sTitel);
        mapParams.put("QUELLDATEI", sQuelldatei);
        mapParams.put("ZIELDATEI", sZieldatei);
        mapParams.put("TEXTDATUM", this.getNomen() + "sdatum:");
        mapParams.put("DATUM", Tool.getToday());
        mapParams.put("TEXTUHRZEIT", this.getNomen() + "suhrzeit:");
        mapParams.put("UHRZEIT", Tool.getNow());
        mapParams.put("ANZAHLPAKETE", this.getTextAnzahlPakete(nErrorCode));
        mapParams.put("ARBEITSMODUS", sArbeitsmodus);
        mapParams.put("SCHLUESSEL", sSchluessel);
        mapParams.put("XKMVERSION", sVersion);
        mapParams.put("ENDSTATUS1", sEndstatus1);
        mapParams.put("ENDSTATUS2", sEndstatus2);
        if (sPruefinfo != null) {
            mapParams.put("TEXTPRUEFINFO", "Kommunikationssatz:");
            mapParams.put("PRUEFINFO", sPruefinfo);
        }
        try {
            File f = new File(this.m_Schalter.getSystemDir() + "/XKMProtokoll.jasper");
            this.m_jasperReport = (JasperReport)JRLoader.loadObject((File)f);
            if (this.m_jasperPrint == null) {
                this.m_jasperPrint = JasperFillManager.fillReport((JasperReport)this.m_jasperReport, mapParams, (JRDataSource)new JREmptyDataSource());
            }
            if (nFormat == 3) {
                JasperExportManager.exportReportToHtmlFile((JasperPrint)this.m_jasperPrint, (String)sFilename);
            } else if (nFormat == 2) {
                JasperExportManager.exportReportToPdfFile((JasperPrint)this.m_jasperPrint, (String)sFilename);
            } else if (nFormat == 4) {
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.m_jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)sFilename);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
                exporter.exportReport();
            } else if (nFormat == 1) {
                this.writeTxt(sFilename, sTitel, sQuelldatei, sZieldatei, sPruefinfo, sArbeitsmodus, sSchluessel, sVersion, sEndstatus1, sEndstatus2, sException, nErrorCode);
            } else if (nFormat == 5) {
                JRXmlExporter exporter = new JRXmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.m_jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)sFilename);
                exporter.setParameter((JRExporterParameter)JRXmlExporterParameter.IS_EMBEDDING_IMAGES, (Object)Boolean.TRUE);
                exporter.exportReport();
            } else if (nFormat == 6) {
                JRSaver.saveObject((Object)this.m_jasperPrint, (String)sFilename);
            } else if (nFormat == 7) {
                JRCsvExporter exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.m_jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)sFilename);
                exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)",");
                exporter.exportReport();
            } else if (nFormat == 8) {
                JRRtfExporter exporter = new JRRtfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.m_jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)sFilename);
                exporter.exportReport();
            } else if (nFormat == 9) {
                JasperPrintManager.printReport((JasperPrint)this.m_jasperPrint, (boolean)false);
            } else if (nFormat == 10) {
                JasperPrintManager.printReport((JasperPrint)this.m_jasperPrint, (boolean)true);
            }
        }
        catch (HeadlessException e) {
            LOG.error("Methode: 'writeFormat'. Protokollformat wird nicht unterstuetzt. Bitte Ausgabeformat TEXT verwenden.");
        }
        catch (JRException e) {
            LOG.error("Methode: 'writeFormat'. Fehler beim Erstellen des Protokolls");
        }
    }

    private String getJavaversionWarnung() {
        String sJavaVersionWarnung = "";
        try {
            int javaVersion = Runtime.version().version().get(0);
            if (javaVersion < 17) {
                sJavaVersionWarnung = "Achtung: Auf Ihrem System ist eine Java Version kleiner 17 installiert. In der n\u00e4chsten Version des Kryptomoduls wird diese Version nicht mehr unterst\u00fctzt und das Kryptomodul wird dann nicht mehr starten.";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sJavaVersionWarnung;
    }

    public void create(int nErrorCode, String sErrorMessage) {
        try {
            String sEndstatus1 = "     *** Errorlevel - Endstatus: " + nErrorCode + " - " + XKMException.getErrorText(nErrorCode) + " ***";
            Object sEndstatus2 = "";
            if (nErrorCode == 3) {
                sEndstatus2 = this.m_sException;
            } else {
                sEndstatus2 = "Die Datei konnte nicht " + this.getVerb() + " werden.";
                if (nErrorCode == 0) {
                    sEndstatus2 = "Die Datei konnte ohne Probleme " + this.getVerb() + " werden.";
                } else if (nErrorCode == 2) {
                    sEndstatus2 = "Es konnte keine zu entschl\u00fcsselnde Datei gefunden werden.";
                }
                if (!this.m_sArbeitsmodus.equals("HDRG_Verschluesselung") && this.m_Arbeitsmodi.memberOf("Abrechnungs_Verschluesselung") && Tool.endsWithIgnoreCase(this.m_sQuellDatei, ".CON") && !this.m_sArbeitsmodus.equals(this.m_Arbeitsmodi.getModusName(7))) {
                    sEndstatus2 = "Warnung ! F\u00fcr Dateien mit Endung '.con' existiert ein eigener Arbeitsmodus !";
                    LOG.warn("Warnung ! Fuer Dateien mit Endung '.con' existiert ein eigener Arbeitsmodus !");
                }
                if (this.m_bTestModus) {
                    sEndstatus2 = "Die erstellte Datei darf nur zu Testzwecken verwendet werden (Testschl\u00fcssel) !!!";
                }
            }
            String sZieldatei = this.m_sZielDatei != null ? this.m_sZielDatei : "";
            this.m_sQuellDatei = Tool.shortenFilename(this.m_sQuellDatei, 72);
            sZieldatei = Tool.shortenFilename(sZieldatei, 72);
            this.m_sSchluessel = Tool.shortenFilename(this.m_sSchluessel, 72);
            this.m_sPruefinfo = Tool.shortenFilename(this.m_sPruefinfo, 72);
            if (this.m_Schalter.getProtokollFormat() == null) {
                AusgabeFormat.getInstance().setFormatPDF(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("TEXT")) {
                AusgabeFormat.getInstance().setFormatTXT(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PDF")) {
                AusgabeFormat.getInstance().setFormatPDF(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("HTML")) {
                AusgabeFormat.getInstance().setFormatHTML(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("XLS")) {
                AusgabeFormat.getInstance().setFormatXLS(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("XML")) {
                AusgabeFormat.getInstance().setFormatXML(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("JRPRINT")) {
                AusgabeFormat.getInstance().setFormatJRPRINT(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("CSV")) {
                AusgabeFormat.getInstance().setFormatCSV(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("RTF")) {
                AusgabeFormat.getInstance().setFormatRTF(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PRINTER")) {
                AusgabeFormat.getInstance().setFormatPRINTER(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PRINTER_DIALOG")) {
                AusgabeFormat.getInstance().setFormatPRINTERDIALOG(true);
            } else if (this.m_Schalter.getProtokollFormat().equalsIgnoreCase("KEIN")) {
                AusgabeFormat.getInstance().setFormatKEIN(true);
            } else {
                AusgabeFormat.getInstance().setFormatPDF(true);
            }
            this.m_jasperPrint = null;
            ArrayList arrayList = AusgabeFormat.getInstance().getAktiveFormate();
            for (int i = 0; i < arrayList.size(); ++i) {
                int nFormat = (Integer)arrayList.get(i);
                if (nFormat == 11) continue;
                this.writeFormat(nFormat, this.buildProtokollname(nFormat), sUeberschrift, this.m_sQuellDatei != null ? this.m_sQuellDatei : "", sZieldatei, this.m_sPruefinfo, this.m_sArbeitsmodus != null ? this.m_sArbeitsmodus : "", this.m_sSchluessel != null ? this.m_sSchluessel : "", Main.cVERSION, sEndstatus1, (String)sEndstatus2, nErrorCode, this.m_sException);
            }
            this.m_sException = null;
            this.m_sPruefinfo = null;
        }
        catch (Exception e) {
            LOG.error("Methode: 'create': Fehler beim Erstellen des Protokolls");
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

