/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.xml;

import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.ExternerArbeitsmodus;
import de.kbv.xkm.krypto.KryptTyp;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLExterneArbeitsmodi
extends DefaultHandler {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    private final ArrayList m_xmlProperties;
    private StringBuffer m_sBuffer;
    private ExternerArbeitsmodus m_externerArbeitsmodus;
    private String m_sException;
    private final Schalter m_Schalter;

    public XMLExterneArbeitsmodi(Schalter schalter) {
        this.m_Schalter = schalter;
        this.m_xmlProperties = new ArrayList();
    }

    public ArrayList getProperties() {
        return this.m_xmlProperties;
    }

    public void load(String sFile) throws XKMException {
        if (sFile != null && sFile != "Konfig/schluessel.xml" && !new File(sFile).isFile()) {
            throw new XKMException(3, "Datei f\u00fcr benutzerdefinierte Schl\u00fcsselerweiterungen '" + sFile + "' nicht gefunden");
        }
        this.m_xmlProperties.clear();
        this.m_sException = null;
        XMLExterneArbeitsmodi handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            FileInputStream fis = new FileInputStream(sFile);
            saxParser.parse((InputStream)fis, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            LOG.error((Object)t);
            throw new XKMException(3, "Fehler beim Parsen der Datei " + sFile);
        }
        if (this.m_sException != null) {
            throw new XKMException(3, this.m_sException);
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.m_sBuffer = new StringBuffer(256);
        if (qName.toLowerCase().equals("arbeitsmodus")) {
            this.m_externerArbeitsmodus = new ExternerArbeitsmodus();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String s;
        if (qName.toLowerCase().equals("arbeitsmodus")) {
            this.m_xmlProperties.add(this.m_externerArbeitsmodus);
        } else if (!qName.toLowerCase().equals("arbeitsmodi") && !(s = this.m_sBuffer.toString().trim()).equals("")) {
            if (qName.toLowerCase().equals("name")) {
                this.m_externerArbeitsmodus.sName = s;
                for (int i = 0; i < this.m_xmlProperties.size(); ++i) {
                    ExternerArbeitsmodus ea = (ExternerArbeitsmodus)this.m_xmlProperties.get(i);
                    if (!ea.sName.toLowerCase().equals(s.toLowerCase())) continue;
                    this.m_sException = "Doppelte bezeichnete Arbeitsmodi in Datei '" + this.m_Schalter.getExternModiDatei() + "'";
                }
            } else if (qName.toLowerCase().equals("typ")) {
                if (!s.toLowerCase().equals("verschluesselung") && !s.toLowerCase().equals("entschluesselung")) {
                    this.m_sException = "Ung\u00fcltiger Wert zu Element 'typ'";
                } else {
                    this.m_externerArbeitsmodus.nTyp = s.equals("verschluesselung") ? KryptTyp.Verschluesselung : KryptTyp.Entschluesselung;
                }
            } else if (qName.toLowerCase().equals("schluessel")) {
                this.m_externerArbeitsmodus.sSchluessel = s;
            } else {
                this.m_sException = "Unbekanntes Element '" + s + "'in Datei '" + this.m_Schalter.getExternModiDatei() + "'";
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.m_sBuffer.append(buf, offset, len);
    }
}

