/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk.pdf.abgleichVsLDT;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.MeldungPool;
import de.kbv.xpm.modul.ldk.pdf.PDFAllgemeinPruefungen;
import de.kbv.xpm.modul.ldk.pdf.abgleichVsLDT.LDTFelder;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderGemeinsam;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10A;
import de.kbv.xpm.modul.ldk.pdf.pruefung.XpmPdfFeld;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class PDFvsLDTPruefungen
extends PDFAllgemeinPruefungen {
    private final LDTFelder ldtDateiFelder;
    private boolean postfachAdresse;
    private boolean isEilt;
    private boolean isTelefon;
    private boolean isFax;

    public PDFvsLDTPruefungen(PDDocument pdfDocument, LDTFelder ldtDateiFelder) {
        this.pdfDocument = pdfDocument;
        this.ldtDateiFelder = ldtDateiFelder;
        m_MeldungPool = MeldungPool.getInstance();
    }

    public void pruefeMuster10GegenLDT() throws XPMException {
        boolean isEingeschraenkterLA;
        boolean isKontrolluntersuchung;
        FormularfelderMuster10 formular10Felder = (FormularfelderMuster10)this.pdfFelder;
        this.checkLeistungsart(formular10Felder, false);
        this.checkDiagnoseMuster10(formular10Felder);
        if (formular10Felder.getKontrolluntersuchung_bekannte_Infektion_4231().getPdField() != null && (isKontrolluntersuchung = ((PDCheckBox)formular10Felder.getKontrolluntersuchung_bekannte_Infektion_4231().getPdField()).isChecked()) && !"1".equals(this.ldtDateiFelder.getFeldValueForFeldName("4231"))) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-007", formular10Felder.getKontrolluntersuchung_bekannte_Infektion_4231().getName(), "4231", "1");
        }
        if (formular10Felder.getEingeschraenkter_Leistungsanspruch_4204().getPdField() != null && (isEingeschraenkterLA = ((PDCheckBox)formular10Felder.getEingeschraenkter_Leistungsanspruch_4204().getPdField()).isChecked()) && !"1".equals(this.ldtDateiFelder.getFeldValueForFeldName("4204"))) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-007", formular10Felder.getEingeschraenkter_Leistungsanspruch_4204().getName(), "4204", "1");
        }
        this.pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(formular10Felder.getErstveranlasser_BSNR_0000(), "4217", "4225");
        this.pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(formular10Felder.getErstveranlasser_LANR_0000(), "4241", "4248");
        if (((FormularfelderMuster10)this.pdfFelder).getTelefonnummer_8118() != null && ((FormularfelderMuster10)this.pdfFelder).getTelefonnummer_8118().getPdField() != null) {
            this.isTelefon = ((PDCheckBox)((FormularfelderMuster10)this.pdfFelder).getTelefonnummer_8118().getPdField()).isChecked();
        }
        if (((FormularfelderMuster10)this.pdfFelder).getFaxnummer_8118() != null && ((FormularfelderMuster10)this.pdfFelder).getFaxnummer_8118().getPdField() != null) {
            this.isFax = ((PDCheckBox)((FormularfelderMuster10)this.pdfFelder).getFaxnummer_8118().getPdField()).isChecked();
        }
        if (this.isEilt && this.isTelefon) {
            this.pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(formular10Felder.getNummer_0000(), "7330", "7331");
        }
        if (formular10Felder.getNummer_0000().getPdField() != null && this.isEilt && this.isFax) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("7333"), formular10Felder.getNummer_0000().getPdField().getValueAsString(), formular10Felder.getNummer_0000().getName(), "7333");
        }
        if (formular10Felder.getBefund_Medikation_4208().getPdField() != null) {
            List<String> liste4208 = this.ldtDateiFelder.getListe4208();
            String pdf4208Content = formular10Felder.getBefund_Medikation_4208().getPdField().getValueAsString();
            pdf4208Content = pdf4208Content.replaceAll("[\r]?\n", " ");
            this.pruefeInhalteEinerListeInString(liste4208, pdf4208Content, "015");
        }
        this.checkAuftrag4205(formular10Felder);
    }

    private void checkAuftrag4205(FormularfelderMuster10 formular10Felder) throws XPMException {
        XpmPdfFeld auftrag_4205 = formular10Felder.getAuftrag_4205();
        if (auftrag_4205.getPdField() != null) {
            String auftrag_4205_StringVal = auftrag_4205.getPdField().getValueAsString();
            auftrag_4205_StringVal = auftrag_4205_StringVal.replaceAll("[\r]?\n", " ");
            List<String> liste7366 = this.ldtDateiFelder.getListe7366();
            List<String> liste7365 = this.ldtDateiFelder.getListe7365();
            List<String> liste8410 = this.ldtDateiFelder.getListe8410();
            List<String> liste8411 = this.ldtDateiFelder.getListe8411();
            List<String> liste8434 = this.ldtDateiFelder.getListe8434();
            if (!(auftrag_4205_StringVal = this.l\u00f6scheInListeGefundenenInhaltAusString(auftrag_4205_StringVal, liste7365)).isEmpty()) {
                auftrag_4205_StringVal = this.l\u00f6scheInListeGefundenenInhaltAusString(auftrag_4205_StringVal, liste7366);
            }
            if (!auftrag_4205_StringVal.isEmpty()) {
                auftrag_4205_StringVal = this.l\u00f6scheInListeGefundenenInhaltAusString(auftrag_4205_StringVal, liste8410);
            }
            if (!auftrag_4205_StringVal.isEmpty()) {
                auftrag_4205_StringVal = this.l\u00f6scheInListeGefundenenInhaltAusString(auftrag_4205_StringVal, liste8411);
            }
            if (!auftrag_4205_StringVal.isEmpty()) {
                auftrag_4205_StringVal = this.l\u00f6scheInListeGefundenenInhaltAusString(auftrag_4205_StringVal, liste8434);
            }
            if (!auftrag_4205_StringVal.trim().isEmpty()) {
                String[] meldungParams = new String[]{auftrag_4205_StringVal, liste7365.toString(), liste7366.toString(), liste8410.toString() + "," + liste8411.toString(), liste8434.toString()};
                m_MeldungPool.addMeldung("KBV-PDFLDT-016", meldungParams);
            }
        }
    }

    private String l\u00f6scheInListeGefundenenInhaltAusString(String string, List<String> liste) {
        String resultString = string;
        for (String einLdtFeld : liste) {
            if (!resultString.contains(einLdtFeld)) continue;
            resultString = resultString.replace(einLdtFeld, "");
        }
        return resultString;
    }

    public void pruefeMuster10AGegenLDT() throws XPMException {
        FormularfelderMuster10A formular10AFelder = (FormularfelderMuster10A)this.pdfFelder;
        this.checkLeistungsart(formular10AFelder, true);
        this.checkAlleAuftraege(formular10AFelder);
        this.checkAuftrag61(formular10AFelder);
        this.checkZusAngabenUntersuchen(formular10AFelder);
    }

    private void checkZusAngabenUntersuchen(FormularfelderMuster10A formular10AFelder) throws XPMException {
        if (formular10AFelder.getZusaetzliche_Angaben_zu_Untersuchungen_0000().getPdField() != null) {
            String ldtFK = "4209";
            String ldtval = this.ldtDateiFelder.getFeldValueForFeldName(ldtFK);
            String pdfval = formular10AFelder.getZusaetzliche_Angaben_zu_Untersuchungen_0000().getPdField().getValueAsString();
            String pdfname = formular10AFelder.getZusaetzliche_Angaben_zu_Untersuchungen_0000().getName();
            this.checkTwoFieldsEqual(ldtval, pdfval, pdfname, ldtFK);
        }
    }

    private void checkAuftrag61(FormularfelderMuster10A formular10AFelder) throws XPMException {
        if (formular10AFelder.getAuftrag61_4205().getPdField() != null && ((PDCheckBox)formular10AFelder.getAuftrag61_4205().getPdField()).isChecked()) {
            if (formular10AFelder.getAuftrag61_sonstige_Auftraege_4205().getPdField() != null) {
                String valAuf61SonstA = formular10AFelder.getAuftrag61_sonstige_Auftraege_4205().getPdField().getValueAsString();
                if (this.ldtDateiFelder.getFeldValueForFeldName("8434") == null || !valAuf61SonstA.equals(this.ldtDateiFelder.getFeldValueForFeldName("8434"))) {
                    m_MeldungPool.addMeldung("KBV-PDFLDT-018");
                }
            } else {
                m_MeldungPool.addMeldung("KBV-PDFLDT-018");
            }
        }
    }

    private void checkAlleAuftraege(FormularfelderMuster10A formular10AFelder) throws XPMException {
        Set<XpmPdfFeld> auftragsliste = formular10AFelder.getAuftragsliste();
        List<String> liste8410 = this.ldtDateiFelder.getListe8410();
        for (XpmPdfFeld auftrag : auftragsliste) {
            boolean idForPDFAuftragIsInListe8410 = false;
            if (auftrag.getPdField() == null || !((PDCheckBox)auftrag.getPdField()).isChecked()) continue;
            String auftragsID = auftrag.getName().replaceAll("4205_Auftrag", "");
            for (String string : liste8410) {
                if (!string.equals(auftragsID)) continue;
                idForPDFAuftragIsInListe8410 = true;
                break;
            }
            if (idForPDFAuftragIsInListe8410) continue;
            m_MeldungPool.addMeldung("KBV-PDFLDT-017", auftragsID);
        }
    }

    private void checkDiagnoseMuster10(FormularfelderMuster10 formular10Felder) throws XPMException {
        if (formular10Felder.getDiagnose_Verdachtsdiagnose_4207().getPdField() != null) {
            List<String> liste4207 = this.ldtDateiFelder.getListe4207();
            String pdf4207Content = formular10Felder.getDiagnose_Verdachtsdiagnose_4207().getPdField().getValueAsString();
            this.pruefeInhalteEinerListeInString(liste4207, pdf4207Content, "012");
        }
    }

    private void pruefeInhalteEinerListeInString(List<String> liste, String pdfContent, String meldungsNummer) throws XPMException {
        String pdfresult = this.l\u00f6scheInListeGefundenenInhaltAusString(pdfContent, liste);
        if (!pdfresult.trim().isEmpty()) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-" + meldungsNummer, pdfContent, liste.toString());
        }
    }

    private void checkLeistungsart(FormularfelderGemeinsam formular10Felder, boolean isMuster10A) throws XPMException {
        if (formular10Felder.getKurativ_4221().getPdField() != null && formular10Felder.getPraeventiv_4221().getPdField() != null && formular10Felder.getBelegaerztliche_Behandlung_4221().getPdField() != null) {
            boolean isKurativ = ((PDCheckBox)formular10Felder.getKurativ_4221().getPdField()).isChecked();
            boolean isPraeventiv = ((PDCheckBox)formular10Felder.getPraeventiv_4221().getPdField()).isChecked();
            boolean isBelegAerztlBehandlung = ((PDCheckBox)formular10Felder.getBelegaerztliche_Behandlung_4221().getPdField()).isChecked();
            boolean isESS = false;
            if (!isMuster10A && ((FormularfelderMuster10)formular10Felder).geteSS_4221().getPdField() != null) {
                isESS = ((PDCheckBox)((FormularfelderMuster10)formular10Felder).geteSS_4221().getPdField()).isChecked();
            }
            String f4221 = this.ldtDateiFelder.getFeldValueForFeldName("4221");
            if (isKurativ && (f4221 == null || !"1".equals(f4221))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-007", formular10Felder.getKurativ_4221().getName(), "4221", "1");
            }
            if (isPraeventiv && (f4221 == null || !"2".equals(f4221))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-007", formular10Felder.getPraeventiv_4221().getName(), "4221", "2");
            }
            if (isBelegAerztlBehandlung && (f4221 == null || !"4".equals(f4221))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-007", formular10Felder.getBelegaerztliche_Behandlung_4221().getName(), "4221", "4");
            }
            if (!(isMuster10A || !isESS || f4221 != null && "3".equals(f4221))) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-007", ((FormularfelderMuster10)formular10Felder).geteSS_4221().getName(), "4221", "3");
            }
        }
    }

    public void pruefeUebergreifendes() throws XPMException {
        boolean isUnfall;
        String ldtval;
        String ldtFK;
        if (this.pdfFelder.getSchwangerschaftswoche_0000().getPdField() != null) {
            ldtFK = "8511";
            ldtval = this.ldtDateiFelder.getFeldValueForFeldName(ldtFK);
            String pdfval = this.pdfFelder.getSchwangerschaftswoche_0000().getPdField().getValueAsString();
            String pdfname = this.pdfFelder.getSchwangerschaftswoche_0000().getName();
            if (ldtval != null && ldtval.trim().length() > 2) {
                ldtval = String.valueOf(Integer.valueOf(ldtval.substring(0, 2)));
            }
            this.checkTwoFieldsEqual(ldtval, pdfval, pdfname, ldtFK);
        }
        if (this.pdfFelder.getEilt_8501() != null && this.pdfFelder.getEilt_8501().getPdField() != null) {
            this.isEilt = ((PDCheckBox)this.pdfFelder.getEilt_8501().getPdField()).isChecked();
            ldtFK = "8501";
            ldtval = this.ldtDateiFelder.getFeldValueForFeldName(ldtFK);
            String pdfname = this.pdfFelder.getEilt_8501().getName();
            if (this.isEilt && !"2".equals(ldtval)) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-007", pdfname, "8501", "2");
            }
        }
        if (this.pdfFelder.getKostentraegername_4134().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("4134"), this.pdfFelder.getKostentraegername_4134().getPdField().getValueAsString(), this.pdfFelder.getKostentraegername_4134().getName(), "4134");
        }
        if (this.pdfFelder.getWop_3116().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3116"), this.pdfFelder.getWop_3116().getPdField().getValueAsString(), this.pdfFelder.getWop_3116().getName(), "3116");
        }
        if (this.pdfFelder.getName_3101().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3101"), this.pdfFelder.getName_3101().getPdField().getValueAsString(), this.pdfFelder.getName_3101().getName(), "3101");
        }
        this.checkVorname();
        this.checkFeldMitMaschinenLesbaremTeil(this.pdfFelder.getGeburtsdatum_3103().getPdField(), "3103", this.pdfFelder.getGeburtsdatum_3103().getName());
        this.checkStrasse();
        this.checkPLZ_WLC_ORT();
        this.checkFeldMitMaschinenLesbaremTeil(this.pdfFelder.getVersicherungsschutzEnde_4110().getPdField(), "4110", this.pdfFelder.getVersicherungsschutzEnde_4110().getName());
        this.checkFeldMitMaschinenLesbaremTeil(this.pdfFelder.getAusstellungsdatum_4102().getPdField(), "7278", this.pdfFelder.getAusstellungsdatum_4102().getName());
        if (this.pdfFelder.getKostentraegerkennung_4111().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("4111"), this.pdfFelder.getKostentraegerkennung_4111().getPdField().getValueAsString(), this.pdfFelder.getKostentraegerkennung_4111().getName(), "4111");
        }
        if (this.pdfFelder.getVersicherten_ID_3119().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3119"), this.pdfFelder.getVersicherten_ID_3119().getPdField().getValueAsString(), this.pdfFelder.getVersicherten_ID_3119().getName(), "3119");
        }
        if (this.pdfFelder.getVersichertenart_3108().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3108"), this.pdfFelder.getVersichertenart_3108().getPdField().getValueAsString(), this.pdfFelder.getVersichertenart_3108().getName(), "3108");
        }
        if (this.pdfFelder.getBesonderePersonengruppe_4131().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("4131"), this.pdfFelder.getBesonderePersonengruppe_4131().getPdField().getValueAsString(), this.pdfFelder.getBesonderePersonengruppe_4131().getName(), "4131");
        }
        if (this.pdfFelder.getDmp_Kennzeichnung_4132().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("4132"), this.pdfFelder.getDmp_Kennzeichnung_4132().getPdField().getValueAsString(), this.pdfFelder.getDmp_Kennzeichnung_4132().getName(), "4132");
        }
        this.checkWeitereKennzeichen();
        this.pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(this.pdfFelder.getBetriebsstaettennummer_0000(), "0222", "0201");
        this.pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(this.pdfFelder.getLebenslangeArztnummer_0000(), "0212", "0223");
        if (this.pdfFelder.getPruefnummer_0000().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("0105"), this.pdfFelder.getPruefnummer_0000().getPdField().getValueAsString(), this.pdfFelder.getPruefnummer_0000().getName(), "0105");
        }
        if (this.pdfFelder.getUnfall_4202().getPdField() != null && (isUnfall = ((PDCheckBox)this.pdfFelder.getUnfall_4202().getPdField()).isChecked()) && (this.ldtDateiFelder.getFeldValueForFeldName("4202") == null || !"1".equals(this.ldtDateiFelder.getFeldValueForFeldName("4202")))) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-007", this.pdfFelder.getUnfall_4202().getName(), "4202", "1");
        }
        if (this.pdfFelder.getLabor_Auftragsnummer_8311().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("8311"), this.pdfFelder.getLabor_Auftragsnummer_8311().getPdField().getValueAsString(), this.pdfFelder.getLabor_Auftragsnummer_8311().getName(), "8311");
        }
        if (this.pdfFelder.getKnappschaftskennziffer_4229().getPdField() != null) {
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("4229"), this.pdfFelder.getKnappschaftskennziffer_4229().getPdField().getValueAsString(), this.pdfFelder.getKnappschaftskennziffer_4229().getName(), "4229");
        }
        this.checkGeschlecht();
        if (this.pdfFelder.getAbnahmedatum_8219().getPdField() != null) {
            String abnahmeDatum = this.getMaschinenLesbarenTeilAusString(this.pdfFelder.getAbnahmedatum_8219().getPdField());
            for (String string : this.ldtDateiFelder.getListe7278()) {
                if (abnahmeDatum == null || abnahmeDatum.equals(string)) continue;
                m_MeldungPool.addMeldung("KBV-PDFLDT-013", this.pdfFelder.getAbnahmedatum_8219().getName(), abnahmeDatum, "7278", string);
            }
        }
        if (this.pdfFelder.getAbnahmezeit_8219().getPdField() != null) {
            String abnahmeZeit = this.pdfFelder.getAbnahmezeit_8219().getPdField().getValueAsString();
            for (String string : this.ldtDateiFelder.getListe7279()) {
                if (string.length() <= 3 || abnahmeZeit.equals(string.substring(0, 4))) continue;
                m_MeldungPool.addMeldung("KBV-PDFLDT-013", this.pdfFelder.getAbnahmezeit_8219().getName(), abnahmeZeit, "7279", string);
            }
        }
        if (this.auftragsnummerDesEinsenders != null && !this.auftragsnummerDesEinsenders.equals(this.ldtDateiFelder.getFeldValueForFeldName("8310"))) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-014", "Auftragsnummer_Einsender", this.auftragsnummerDesEinsenders, "8310", this.ldtDateiFelder.getFeldValueForFeldName("8310"));
        }
    }

    private void checkGeschlecht() throws XPMException {
        if (this.pdfFelder.getGeschlecht_3110() != null) {
            String geschlecht = this.pdfFelder.getGeschlecht_3110().getPdField().getValueAsString();
            String val3110 = this.ldtDateiFelder.getFeldValueForFeldName("3110");
            if ("M".equals(geschlecht) && !"M".equals(val3110)) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-009", "M", "M", val3110);
            } else if ("W".equals(geschlecht) && !"W".equals(val3110)) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-009", "W", "W", val3110);
            } else if ("X".equals(geschlecht) && !"X".equals(val3110)) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-009", "X", "X", val3110);
            } else if ("D".equals(geschlecht) && !"D".equals(val3110)) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-009", "D", "D", val3110);
            }
        }
    }

    private void pruefeObPDFFeldInMindEinemVonZweiLDTFeldernVorkommt(XpmPdfFeld pdfFeld, String ldtFeld1FK, String ldtFeld2FK) throws XPMException {
        String ldtFeld1 = this.ldtDateiFelder.getFeldValueForFeldName(ldtFeld1FK);
        String ldtFeld2 = this.ldtDateiFelder.getFeldValueForFeldName(ldtFeld2FK);
        if (pdfFeld.getPdField() != null) {
            String pdfTextValue = pdfFeld.getPdField().getValueAsString();
            if (pdfTextValue != null && !pdfTextValue.isEmpty()) {
                if ((ldtFeld1 == null || ldtFeld1.isEmpty()) && (ldtFeld2 == null || ldtFeld2.isEmpty())) {
                    m_MeldungPool.addMeldung("KBV-PDFLDT-006", pdfFeld.getName(), ldtFeld1FK, ldtFeld2FK);
                } else if (ldtFeld1 != null && !pdfTextValue.equals(ldtFeld1) && ldtFeld2 != null && !pdfTextValue.equals(ldtFeld2)) {
                    String[] meldungsParameter = new String[]{pdfFeld.getName(), ldtFeld1FK, ldtFeld2FK, pdfTextValue, ldtFeld1, ldtFeld2};
                    m_MeldungPool.addMeldung("KBV-PDFLDT-005", meldungsParameter);
                }
            } else if (ldtFeld1 != null && !ldtFeld1.isEmpty() && ldtFeld2 != null && !ldtFeld2.isEmpty()) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-004", pdfFeld.getName(), ldtFeld1FK, ldtFeld2FK);
            }
        }
    }

    private void checkWeitereKennzeichen() throws XPMException {
        if (this.pdfFelder.getWeitere_Kennzeichen_0000().getPdField() != null) {
            List<String> feldValueForFeldName = this.ldtDateiFelder.getListe7303();
            if ("1".equals(this.pdfFelder.getWeitere_Kennzeichen_0000().getPdField().getValueAsString())) {
                for (String feld7303 : feldValueForFeldName) {
                    if (feld7303 == null || "8".equals(feld7303)) continue;
                    String[] meldungParams = new String[]{this.pdfFelder.getWeitere_Kennzeichen_0000().getName(), "1", "7303", "8", feld7303};
                    m_MeldungPool.addMeldung("KBV-PDFLDT-003", meldungParams);
                }
            }
        }
    }

    private void checkPLZ_WLC_ORT() throws XPMException {
        if (this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getPdField() != null) {
            String wlcPlzOrt = this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getPdField().getValueAsString();
            String wlc = null;
            String plz = null;
            String ort = null;
            try {
                if (this.anzahl_Zeichen_Wohnsitzlaendercode > 0) {
                    wlc = wlcPlzOrt.substring(0, this.anzahl_Zeichen_Wohnsitzlaendercode);
                    ++this.anzahl_Zeichen_Wohnsitzlaendercode;
                }
                if (this.anzahl_Zeichen_Postleitzahl > 0) {
                    plz = wlcPlzOrt.substring(this.anzahl_Zeichen_Wohnsitzlaendercode, this.anzahl_Zeichen_Wohnsitzlaendercode + this.anzahl_Zeichen_Postleitzahl);
                    ++this.anzahl_Zeichen_Postleitzahl;
                }
                ort = wlcPlzOrt.substring(this.anzahl_Zeichen_Wohnsitzlaendercode + this.anzahl_Zeichen_Postleitzahl);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-019", this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getName());
            }
            if (!this.postfachAdresse) {
                this.check_WLC_PLZ_ORT_FelderGegenLDT(wlc, plz, ort, "3114", "3112", "3113");
            } else {
                this.check_WLC_PLZ_ORT_FelderGegenLDT(wlc, plz, ort, "3124", "3121", "3122");
            }
        }
    }

    private void check_WLC_PLZ_ORT_FelderGegenLDT(String wlc, String plz, String ort, String ldtWlc, String ldtPlz, String ldtOrt) throws XPMException {
        this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName(ldtWlc), wlc, "Wohnsitzl\u00e4ndercode aus dem Feld " + this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getName(), ldtWlc);
        this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName(ldtPlz), plz, "Postleitzahl aus dem Feld " + this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getName(), ldtPlz);
        this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName(ldtOrt), ort, "Ort aus dem Feld " + this.pdfFelder.getWohnsitzlaendercode_PLZ_Ort_0000().getName(), ldtOrt);
    }

    private void checkStrasse() throws XPMException {
        if (this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getPdField() != null) {
            String strasseHausnummer = this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getPdField().getValueAsString();
            this.postfachAdresse = false;
            String strasse = strasseHausnummer;
            String hausnummer = null;
            if (strasseHausnummer.contains("Postfach")) {
                String postfach = null;
                if (strasseHausnummer.length() > strasseHausnummer.indexOf("Postfach") + 8) {
                    postfach = strasseHausnummer.substring(strasseHausnummer.indexOf("Postfach") + 8).trim();
                }
                this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3123"), postfach, "Postfach aus dem Feld " + this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getName(), "3123");
                this.postfachAdresse = true;
            } else {
                if (this.anzahl_Zeichen_Hausnummer > 0) {
                    try {
                        if (strasseHausnummer.length() <= 30) {
                            strasse = strasseHausnummer.substring(0, strasseHausnummer.length() - this.anzahl_Zeichen_Hausnummer).trim();
                            hausnummer = strasseHausnummer.substring(strasseHausnummer.length() - this.anzahl_Zeichen_Hausnummer, strasseHausnummer.length());
                        } else {
                            String strasseHausnummerSichtbarerTeil = strasseHausnummer.substring(0, 30);
                            hausnummer = strasseHausnummerSichtbarerTeil.substring(30 - this.anzahl_Zeichen_Hausnummer, 30);
                            strasse = strasseHausnummer.substring(31);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        m_MeldungPool.addMeldung("KBV-PDFLDT-019", this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getName());
                    }
                }
                this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3107"), strasse, "Stra\u00dfe aus dem Feld " + this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getName(), "3107");
                this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName("3109"), hausnummer, "Hausnummer aus dem Feld " + this.pdfFelder.getStra\u00dfe_Hausnummer_0000().getName(), "3109");
            }
        }
    }

    private void checkFeldMitMaschinenLesbaremTeil(PDField pdField, String ldtFeldKennung, String pdfFeldName) throws XPMException {
        if (pdField != null) {
            String maschinenLesbarGeb = this.getMaschinenLesbarenTeilAusString(pdField);
            this.checkTwoFieldsEqual(this.ldtDateiFelder.getFeldValueForFeldName(ldtFeldKennung), maschinenLesbarGeb, pdfFeldName, ldtFeldKennung);
        }
    }

    private String getMaschinenLesbarenTeilAusString(PDField pdField) {
        String pdfFeldStringValue = pdField.getValueAsString();
        String[] split = pdfFeldStringValue.split(" ");
        String maschinenLesbarGeb = null;
        if (split.length > 1) {
            maschinenLesbarGeb = split[1];
        }
        return maschinenLesbarGeb;
    }

    private void checkVorname() throws XPMException {
        XpmPdfFeld namensFelder = this.pdfFelder.getTitel_Vorname_Namenszusatz_Vorsatzwort_0000();
        if (namensFelder != null && namensFelder.getPdField() != null) {
            String stringNamensFelderPDF = namensFelder.getPdField().getValueAsString();
            String pdfTitel = null;
            String pdfVorname = null;
            String pdfNamenszusatz = null;
            String pdfVorsatzwort = null;
            try {
                if (this.anzahl_Zeichen_Titel != 0) {
                    pdfTitel = stringNamensFelderPDF.substring(0, this.anzahl_Zeichen_Titel);
                    ++this.anzahl_Zeichen_Titel;
                }
                if (this.anzahl_Zeichen_Vorname != 0) {
                    pdfVorname = stringNamensFelderPDF.substring(this.anzahl_Zeichen_Titel, this.anzahl_Zeichen_Titel + this.anzahl_Zeichen_Vorname);
                    ++this.anzahl_Zeichen_Vorname;
                }
                if (this.anzahl_Zeichen_Namenszusatz != 0) {
                    pdfNamenszusatz = stringNamensFelderPDF.substring(this.anzahl_Zeichen_Titel + this.anzahl_Zeichen_Vorname, this.anzahl_Zeichen_Titel + this.anzahl_Zeichen_Vorname + this.anzahl_Zeichen_Namenszusatz);
                    ++this.anzahl_Zeichen_Namenszusatz;
                }
                if (this.anzahl_Zeichen_Titel + this.anzahl_Zeichen_Vorname + this.anzahl_Zeichen_Namenszusatz <= stringNamensFelderPDF.length()) {
                    pdfVorsatzwort = stringNamensFelderPDF.substring(this.anzahl_Zeichen_Titel + this.anzahl_Zeichen_Vorname + this.anzahl_Zeichen_Namenszusatz);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-019", this.pdfFelder.getTitel_Vorname_Namenszusatz_Vorsatzwort_0000().getName());
            }
            String feld3104 = this.ldtDateiFelder.getFeldValueForFeldName("3104");
            this.checkTwoFieldsEqual(feld3104, pdfTitel, "Titel aus dem Feld " + namensFelder.getName(), "3104");
            String feld3102 = "";
            for (String einVornameAusLdt : this.ldtDateiFelder.getListe3102()) {
                feld3102 = feld3102.concat(einVornameAusLdt);
            }
            this.checkTwoFieldsEqual(feld3102, pdfVorname, "Vorname aus dem Feld " + namensFelder.getName(), "3102");
            String feld3100 = this.ldtDateiFelder.getFeldValueForFeldName("3100");
            this.checkTwoFieldsEqual(feld3100, pdfNamenszusatz, "Namenszusatz aus dem Feld " + namensFelder.getName(), "3100");
            String feld3120 = this.ldtDateiFelder.getFeldValueForFeldName("3120");
            this.checkTwoFieldsEqual(feld3120, pdfVorsatzwort, "Vorsatzwort aus dem Feld " + namensFelder.getName(), "3120");
        }
    }

    private void checkTwoFieldsEqual(String ldtFeld, String xpmpdfFeld, String pdfFeldName, String ldtFeldKennung) throws XPMException {
        if (xpmpdfFeld != null) {
            if (ldtFeld != null && !ldtFeld.isEmpty()) {
                if (!xpmpdfFeld.equals(ldtFeld)) {
                    m_MeldungPool.addMeldung("KBV-PDFLDT-001", pdfFeldName, ldtFeldKennung, xpmpdfFeld, ldtFeld);
                }
            } else if (!xpmpdfFeld.isEmpty()) {
                m_MeldungPool.addMeldung("KBV-PDFLDT-002", pdfFeldName, ldtFeldKennung, xpmpdfFeld);
            }
        } else if (xpmpdfFeld == null && ldtFeld != null && !ldtFeld.isEmpty()) {
            m_MeldungPool.addMeldung("KBV-PDFLDT-001", pdfFeldName, ldtFeldKennung, "", ldtFeld);
        }
    }
}

