/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.visitor.cos.gf;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.gf.model.impl.cos.GFCosArray;
import org.verapdf.gf.model.impl.cos.GFCosBool;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosDocument;
import org.verapdf.gf.model.impl.cos.GFCosFileSpecification;
import org.verapdf.gf.model.impl.cos.GFCosIndirect;
import org.verapdf.gf.model.impl.cos.GFCosInteger;
import org.verapdf.gf.model.impl.cos.GFCosName;
import org.verapdf.gf.model.impl.cos.GFCosNull;
import org.verapdf.gf.model.impl.cos.GFCosReal;
import org.verapdf.gf.model.impl.cos.GFCosStream;
import org.verapdf.gf.model.impl.cos.GFCosString;

public class GFCosVisitor
implements ICOSVisitor {
    private GFCosVisitor() {
    }

    public static GFCosVisitor getInstance() {
        return new GFCosVisitor();
    }

    @Override
    public Object visitFromArray(COSArray obj) {
        return new GFCosArray(obj);
    }

    @Override
    public Object visitFromBoolean(COSBoolean obj) {
        return GFCosBool.valueOf(obj);
    }

    @Override
    public Object visitFromDictionary(COSDictionary obj) {
        ASAtom type = obj.getNameKey(ASAtom.TYPE);
        boolean isFileSpec = ASAtom.FILESPEC.equals(type);
        return isFileSpec ? new GFCosFileSpecification(obj, false) : new GFCosDict(obj);
    }

    @Override
    public Object visitFromDocument(COSDocument obj) {
        return new GFCosDocument(obj);
    }

    @Override
    public Object visitFromReal(COSReal obj) {
        return new GFCosReal(obj);
    }

    @Override
    public Object visitFromInteger(COSInteger obj) {
        return new GFCosInteger(obj);
    }

    @Override
    public Object visitFromName(COSName obj) {
        return new GFCosName(obj);
    }

    @Override
    public Object visitFromNull(COSNull obj) {
        return GFCosNull.getInstance();
    }

    @Override
    public Object visitFromStream(COSStream obj) {
        return new GFCosStream(obj);
    }

    @Override
    public Object visitFromString(COSString obj) {
        return new GFCosString(obj);
    }

    public static Object visitFromIndirect(COSIndirect obj) {
        if (obj.getDirect() == null) {
            return GFCosNull.getInstance();
        }
        return new GFCosIndirect(obj);
    }
}

