/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.flavours;

import java.util.List;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PDFFlavours {
    public static boolean isOnlyPDFUARelatedFlavour(List<PDFAFlavour> flavours) {
        for (PDFAFlavour flavour : flavours) {
            if (PDFFlavours.isPDFUARelatedFlavour(flavour)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPDFUARelatedFlavour(List<PDFAFlavour> flavours) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isPDFUARelatedFlavour(flavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFUARelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.PDF_UA) || PDFFlavours.isWTPDFFlavour(flavour) || PDFFlavours.isWCAGFlavour(flavour);
    }

    public static boolean isPDFUA1RelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavour(flavour, PDFAFlavour.PDFUA_1) || PDFFlavours.isWCAGFlavour(flavour);
    }

    public static boolean isPDFUA2RelatedFlavour(List<PDFAFlavour> flavours) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isPDFUA2RelatedFlavour(flavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFUA2RelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavour(flavour, PDFAFlavour.PDFUA_2) || PDFFlavours.isFlavourPart(flavour, PDFAFlavour.Specification.WTPDF_1_0);
    }

    public static boolean isWCAGFlavour(List<PDFAFlavour> flavours) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isWCAGFlavour(flavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWCAGFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.WCAG);
    }

    public static boolean isWTPDFFlavour(List<PDFAFlavour> flavours) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isWTPDFFlavour(flavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWTPDFFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.WTPDF);
    }

    public static boolean isFlavour(List<PDFAFlavour> flavours, PDFAFlavour checkedFlavour) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isFlavour(flavour, checkedFlavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnlyFlavour(List<PDFAFlavour> flavours, PDFAFlavour checkedFlavour) {
        for (PDFAFlavour flavour : flavours) {
            if (PDFFlavours.isFlavour(flavour, checkedFlavour)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFlavour(PDFAFlavour currentFlavour, PDFAFlavour checkedFlavour) {
        return currentFlavour == checkedFlavour;
    }

    public static boolean isFlavourFamily(PDFAFlavour flavour, PDFAFlavour.SpecificationFamily family) {
        return flavour != null && flavour.getPart().getFamily() == family;
    }

    public static boolean isFlavourPart(List<PDFAFlavour> flavours, PDFAFlavour.Specification part) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isFlavourPart(flavour, part)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlavourPart(PDFAFlavour flavour, PDFAFlavour.Specification part) {
        return flavour != null && flavour.getPart() == part;
    }

    public static boolean isPDFSpecification(List<PDFAFlavour> flavours, PDFAFlavour.PDFSpecification pdfSpecification) {
        for (PDFAFlavour flavour : flavours) {
            if (!PDFFlavours.isPDFSpecification(flavour, pdfSpecification)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFSpecification(PDFAFlavour flavour, PDFAFlavour.PDFSpecification pdfSpecification) {
        return flavour != null && flavour.getPart().getPdfSpecification() == pdfSpecification;
    }

    public static boolean isFlavourISOSeries(PDFAFlavour flavour, PDFAFlavour.IsoStandardSeries isoStandardSeries) {
        return flavour != null && flavour.getPart().getSeries() == isoStandardSeries;
    }
}

