/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.ldk.pdf;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.MeldungPool;
import de.kbv.xpm.modul.ldk.pdf.MusterTyp;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderGemeinsam;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10;
import de.kbv.xpm.modul.ldk.pdf.model.FormularfelderMuster10A;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PDFAllgemeinPruefungen {
    private static final String FTX_CONTROL_DATA_TAGNAME = "ftx:ControlData";
    protected PDDocument pdfDocument;
    protected static MeldungPool m_MeldungPool;
    protected MusterTyp musterTyp;
    protected static final Logger logger_;
    protected FormularfelderGemeinsam pdfFelder;
    private String formularnummerStr;
    protected int anzahl_Zeichen_Titel;
    protected int anzahl_Zeichen_Vorname;
    protected int anzahl_Zeichen_Namenszusatz;
    protected int anzahl_Zeichen_Hausnummer;
    protected int anzahl_Zeichen_Wohnsitzlaendercode;
    protected int anzahl_Zeichen_Postleitzahl;
    protected String auftragsnummerDesEinsenders;
    protected String technischeVersion;
    private final String TECHNISCHE_VERSION_VORGABE = "6";

    public void identifyAndSetMusterTyp() throws XPMException {
        PDDocumentCatalog documentCatalog = this.pdfDocument.getDocumentCatalog();
        PDMetadata metadata = documentCatalog.getMetadata();
        if (metadata != null) {
            try {
                this.initMetadata(metadata);
                this.musterTyp = MusterTyp.getMusterTypByMusterCode(this.formularnummerStr);
            }
            catch (IOException e) {
                logger_.error("An error ouccred when parsing the meta data: " + e.getMessage());
            }
        } else {
            throw new XPMException("Das PDF Document enth\u00e4lt keine Metadaten.");
        }
    }

    public void initFormularFelder() throws XPMException {
        ArrayList<String> signaturFelder = new ArrayList<String>();
        PDDocumentCatalog pdCatalog = this.pdfDocument.getDocumentCatalog();
        PDAcroForm pdAcroForm = pdCatalog.getAcroForm();
        for (PDField pdField : pdAcroForm.getFields()) {
            if (!pdField.getValueAsString().startsWith("org.apache.pdfbox.pdmodel.interactive.digitalsignature.")) continue;
            signaturFelder.add(pdField.getPartialName());
        }
        signaturFelder.add("0000_QES");
        this.pdfFelder = null;
        if (this.musterTyp == MusterTyp.Muster_10) {
            this.pdfFelder = new FormularfelderMuster10();
        } else if (this.musterTyp == MusterTyp.Muster_10A) {
            this.pdfFelder = new FormularfelderMuster10A();
        }
        PDDocumentCatalog documentCatalog = this.pdfDocument.getDocumentCatalog();
        PDAcroForm form = documentCatalog.getAcroForm();
        List<PDField> fields = form.getFields();
        for (PDField field : fields) {
            if (this.pdfFelder.setFeld(field.getPartialName(), field) || signaturFelder.contains(field.getPartialName())) continue;
            m_MeldungPool.addMeldung("KBV-PDF-2", field.getPartialName(), this.musterTyp.toString());
        }
    }

    private void initMetadata(PDMetadata metadata) throws IOException, XPMException {
        try {
            COSInputStream xmlInputStream = metadata.createInputStream();
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            f.setExpandEntityReferences(true);
            f.setIgnoringComments(true);
            f.setIgnoringElementContentWhitespace(true);
            f.setValidating(false);
            f.setCoalescing(true);
            f.setNamespaceAware(true);
            DocumentBuilder builder = f.newDocumentBuilder();
            Document xmpDoc = builder.parse(xmlInputStream);
            this.anzahl_Zeichen_Titel = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Titel");
            this.formularnummerStr = this.getMetaDatumAsString(xmpDoc, "control:Formularnummer");
            this.anzahl_Zeichen_Vorname = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Vorname");
            this.anzahl_Zeichen_Namenszusatz = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Namenszusatz");
            this.anzahl_Zeichen_Wohnsitzlaendercode = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Wohnsitzlaendercode");
            this.anzahl_Zeichen_Postleitzahl = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Postleitzahl");
            this.anzahl_Zeichen_Hausnummer = this.getMetaDatum(xmpDoc, "control:Anzahl_Zeichen_Hausnummer");
            this.auftragsnummerDesEinsenders = this.getMetaDatumAsString(xmpDoc, "control:Auftragsnummer_Einsender");
            this.technischeVersion = this.getMetaDatumAsString(xmpDoc, "control:Technische_Version");
            if (this.formularnummerStr.equals("10")) {
                if (this.technischeVersion == null) {
                    m_MeldungPool.addMeldung("KBV-PDF-TV", this.technischeVersion, "8");
                } else if (!(this.technischeVersion.equals("7") || this.technischeVersion.equals("8") || this.technischeVersion.equals("6"))) {
                    m_MeldungPool.addMeldung("KBV-PDF-TV", this.technischeVersion, "8");
                }
            }
            ((InputStream)xmlInputStream).close();
            try {
                int javaVersion = Runtime.version().version().get(0);
                if (javaVersion < 17) {
                    m_MeldungPool.addMeldung("JAVAVERSION");
                }
            }
            catch (Exception exception) {}
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new XPMException("PDF-Metadaten fehlerhaft: \n" + e.getMessage());
        }
    }

    @SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="Kann hier nicht passieren da Fehlermeldung vom XPM selbst kommt.")
    private int getMetaDatum(Document xmpDoc, String tagName) throws DOMException {
        Node item;
        NamedNodeMap attributes;
        Node namedItem;
        NodeList elementsByTagName;
        Node item2;
        String content;
        NodeList liste = xmpDoc.getElementsByTagName(tagName);
        if (liste.getLength() > 0 && (content = (item2 = liste.item(0)).getTextContent()) != null) {
            try {
                return Integer.parseInt(content);
            }
            catch (NumberFormatException e) {
                logger_.error("Fehler beim Parsen zu Integer von:" + content);
            }
        }
        if ((elementsByTagName = xmpDoc.getElementsByTagName(FTX_CONTROL_DATA_TAGNAME)).getLength() > 0 && (namedItem = (attributes = (item = elementsByTagName.item(0)).getAttributes()).getNamedItem(tagName)) != null && namedItem.getTextContent() != null) {
            try {
                return Integer.parseInt(namedItem.getTextContent());
            }
            catch (NumberFormatException e) {
                logger_.error("Fehler beim Parsen zu Integer von:" + namedItem.getTextContent());
            }
        }
        return 0;
    }

    private String getMetaDatumAsString(Document xmpDoc, String tagName) throws DOMException {
        Node item;
        NamedNodeMap attributes;
        Node namedItem;
        Node item2;
        String content;
        NodeList liste = xmpDoc.getElementsByTagName(tagName);
        if (liste.getLength() > 0 && (content = (item2 = liste.item(0)).getTextContent()) != null) {
            return content;
        }
        NodeList elementsByTagName = xmpDoc.getElementsByTagName(FTX_CONTROL_DATA_TAGNAME);
        if (elementsByTagName.getLength() > 0 && (namedItem = (attributes = (item = elementsByTagName.item(0)).getAttributes()).getNamedItem(tagName)) != null) {
            return namedItem.getTextContent();
        }
        return "";
    }

    public MusterTyp getMusterTyp() {
        return this.musterTyp;
    }

    static {
        logger_ = LogManager.getLogger(PDFAllgemeinPruefungen.class);
    }
}

