/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import org.verapdf.containers.StaticCoreContainers;
import org.verapdf.model.impl.axl.AXLXMPObject;
import org.verapdf.model.tools.xmp.SchemasDefinition;
import org.verapdf.model.tools.xmp.SchemasDefinitionCreator;
import org.verapdf.model.xmplayer.XMPProperty;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLXMPProperty
extends AXLXMPObject
implements XMPProperty {
    public static final String XMP_PROPERTY_TYPE = "XMPProperty";
    protected final VeraPDFXMPNode xmpNode;
    private final boolean isMainMetadata;
    private final boolean isClosedChoiceCheck;
    private final SchemasDefinition mainPackageSchemasDefinition;
    private final SchemasDefinition currentSchemasDefinitionPDFA_1;
    private final SchemasDefinition currentSchemasDefinitionPDFA_2_3;

    public AXLXMPProperty(VeraPDFXMPNode xmpNode, boolean isMainMetadata, boolean isClosedChoiceCheck, SchemasDefinition mainPackageSchemasDefinition, SchemasDefinition currentSchemasDefinitionPDFA_1, SchemasDefinition currentSchemasDefinitionPDFA_2_3) {
        this(xmpNode, XMP_PROPERTY_TYPE, isMainMetadata, isClosedChoiceCheck, mainPackageSchemasDefinition, currentSchemasDefinitionPDFA_1, currentSchemasDefinitionPDFA_2_3);
    }

    protected AXLXMPProperty(VeraPDFXMPNode xmpNode, String type, boolean isMainMetadata, boolean isClosedChoiceCheck, SchemasDefinition mainPackageSchemasDefinition, SchemasDefinition currentSchemasDefinitionPDFA_1, SchemasDefinition currentSchemasDefinitionPDFA_2_3) {
        super(type);
        this.xmpNode = xmpNode;
        this.isMainMetadata = isMainMetadata;
        this.isClosedChoiceCheck = isClosedChoiceCheck;
        this.mainPackageSchemasDefinition = mainPackageSchemasDefinition;
        this.currentSchemasDefinitionPDFA_1 = currentSchemasDefinitionPDFA_1;
        this.currentSchemasDefinitionPDFA_2_3 = currentSchemasDefinitionPDFA_2_3;
        this.contextDependent = Boolean.TRUE;
    }

    @Override
    public String getID() {
        return this.xmpNode.getNamespaceURI() + " - " + this.xmpNode.getPrefix() + ":" + this.xmpNode.getName();
    }

    @Override
    public Boolean getisPredefinedInXMP2004() {
        return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisPredefinedInXMP2005() {
        return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisDefinedInCurrentPackage() {
        if (PDFFlavours.isFlavourPart(StaticCoreContainers.getFlavour(), PDFAFlavour.Specification.ISO_19005_1)) {
            return this.currentSchemasDefinitionPDFA_1.isDefinedProperty(this.xmpNode);
        }
        return this.currentSchemasDefinitionPDFA_2_3.isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisDefinedInMainPackage() {
        return (this.isMainMetadata ? this.currentSchemasDefinitionPDFA_2_3 : this.mainPackageSchemasDefinition).isDefinedProperty(this.xmpNode);
    }

    @Override
    public Boolean getisValueTypeCorrect() {
        if (this.xmpNode == null) {
            return Boolean.FALSE;
        }
        SchemasDefinition schemasDefinition = this.getSchemasDefinition();
        return schemasDefinition != null ? schemasDefinition.isCorrespondsDefinedType(this.xmpNode) : null;
    }

    @Override
    public String getpredefinedType() {
        if (this.xmpNode == null) {
            return null;
        }
        SchemasDefinition schemasDefinition = this.getSchemasDefinition();
        return schemasDefinition != null ? schemasDefinition.getDefinedType(this.xmpNode) : null;
    }

    private SchemasDefinition getSchemasDefinition() {
        if (PDFFlavours.isFlavourPart(StaticCoreContainers.getFlavour(), PDFAFlavour.Specification.ISO_19005_1)) {
            if (this.currentSchemasDefinitionPDFA_1.isDefinedProperty(this.xmpNode)) {
                return this.currentSchemasDefinitionPDFA_1;
            }
            if (SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode)) {
                return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_1(this.isClosedChoiceCheck);
            }
        } else {
            if (this.currentSchemasDefinitionPDFA_2_3.isDefinedProperty(this.xmpNode)) {
                return this.currentSchemasDefinitionPDFA_2_3;
            }
            if (this.mainPackageSchemasDefinition.isDefinedProperty(this.xmpNode)) {
                return this.mainPackageSchemasDefinition;
            }
            if (SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck).isDefinedProperty(this.xmpNode)) {
                return SchemasDefinitionCreator.getPredefinedSchemaDefinitionForPDFA_2_3(this.isClosedChoiceCheck);
            }
        }
        return null;
    }
}

