/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import java.awt.color.ColorSpace;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.pd.colors.PDColorSpace;

public class PDDeviceRGB
extends PDColorSpace {
    public static final PDDeviceRGB INSTANCE = new PDDeviceRGB(false);
    public static final PDDeviceRGB INHERITED_INSTANCE = new PDDeviceRGB(true);
    private final ColorSpace colorSpaceRGB = ColorSpace.getInstance(1000);

    private PDDeviceRGB(boolean isInherited) {
        super(COSName.construct(ASAtom.DEVICERGB));
        this.setInherited(isInherited);
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.DEVICERGB;
    }

    @Override
    public double[] toRGB(double[] value) {
        float[] rgb = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            rgb[i] = (float)value[i];
        }
        rgb = this.colorSpaceRGB.toRGB(rgb);
        return new double[]{rgb[0], rgb[1], rgb[2]};
    }
}

