/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;

public class PDFontDescriptor
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDFontDescriptor.class.getCanonicalName());
    private final Long flags = this.getFlags();
    private static final int FIXED_PITCH_BIT = 1;
    private static final int SERIF_BIT = 2;
    private static final int SYMBOLIC_BIT = 3;
    private static final int SCRIPT_BIT = 4;
    private static final int NONSYMBOLIC_BIT = 6;
    private static final int ITALIC_BIT = 7;
    private static final int ALL_CAP_BIT = 17;
    private static final int SMALL_CAP_BIT = 18;
    private static final int FORCE_BOLD_BIT = 19;
    private static final Double DEFAULT_LEADING = 0.0;
    private static final Double DEFAULT_XHEIGHT = 0.0;
    private static final Double DEFAULT_STEM_H = 0.0;
    private static final Double DEFAULT_WIDTH = 0.0;
    private String fontName;
    private String fontFamily;
    private ASAtom fontStretch;
    private Double fontWeight;
    private Boolean isFixedPitch;
    private Boolean isSerif;
    private Boolean isSymbolic;
    private Boolean isScript;
    private Boolean isNonSymblic;
    private Boolean isItalic;
    private Boolean isAllCap;
    private Boolean isSmallCup;
    private Boolean isForceBold;
    private double[] fontBoundingBox;
    private Double italicAngle;
    private Double ascent;
    private Double descent;
    private Double leading;
    private Double capHeight;
    private Double xHeight;
    private Double stemV;
    private Double stemH;
    private Double avgWidth;
    private Double maxWidth;
    private Double missingWidth;
    private String charSet;

    public PDFontDescriptor(COSObject obj) {
        super(obj != null ? obj : COSDictionary.construct());
        String string = this.fontName = this.getFontName() == null ? "" : this.getFontName().getValue();
        if (this.flags == null && obj != null) {
            LOGGER.log(Level.FINE, "Font descriptor for font " + this.fontName + " doesn't contain flags.");
        }
    }

    public Long getFlags() {
        return this.getIntegerKey(ASAtom.FLAGS);
    }

    public ASAtom getFontName() {
        return this.getNameKey(ASAtom.FONT_NAME);
    }

    public String getFontFamily() {
        if (this.fontFamily == null) {
            this.fontFamily = this.getStringKey(ASAtom.FONT_FAMILY);
        }
        return this.fontFamily;
    }

    public ASAtom getFontStretch() {
        if (this.fontStretch == null) {
            this.fontStretch = this.getNameKey(ASAtom.FONT_STRETCH);
        }
        return this.fontStretch;
    }

    public Double getFontWeight() {
        if (this.fontWeight == null) {
            this.fontWeight = this.getRealKey(ASAtom.FONT_WEIGHT);
        }
        return this.fontWeight;
    }

    public boolean isFixedPitch() {
        if (this.isFixedPitch == null) {
            this.isFixedPitch = this.isFlagBitOn(1);
        }
        return this.isFixedPitch;
    }

    public boolean isSerif() {
        if (this.isSerif == null) {
            this.isSerif = this.isFlagBitOn(2);
        }
        return this.isSerif;
    }

    public boolean isSymbolic() {
        if (this.isSymbolic == null) {
            this.isSymbolic = this.isFlagBitOn(3);
        }
        return this.isSymbolic;
    }

    public boolean isScript() {
        if (this.isScript == null) {
            this.isScript = this.isFlagBitOn(4);
        }
        return this.isScript;
    }

    public boolean isNonsymbolic() {
        if (this.isNonSymblic == null) {
            this.isNonSymblic = this.isFlagBitOn(6);
        }
        return this.isNonSymblic;
    }

    public boolean isItalic() {
        if (this.isItalic == null) {
            this.isItalic = this.isFlagBitOn(7);
        }
        return this.isItalic;
    }

    public boolean isAllCap() {
        if (this.isAllCap == null) {
            this.isAllCap = this.isFlagBitOn(17);
        }
        return this.isAllCap;
    }

    public boolean isSmallCap() {
        if (this.isSmallCup == null) {
            this.isSmallCup = this.isFlagBitOn(18);
        }
        return this.isSmallCup;
    }

    public boolean isForceBold() {
        if (this.isForceBold == null) {
            this.isForceBold = this.isFlagBitOn(19);
        }
        return this.isForceBold;
    }

    private boolean isFlagBitOn(int bit) {
        return this.flags != null && (this.flags.intValue() & 1 << bit - 1) != 0;
    }

    public double[] getFontBoundingBox() {
        COSBase bbox;
        if (this.fontBoundingBox == null && (bbox = this.getObject().getKey(ASAtom.FONT_BBOX).get()) != null) {
            if (bbox.getType() == COSObjType.COS_ARRAY && bbox.size() == 4) {
                double[] res = new double[4];
                for (int i = 0; i < 4; ++i) {
                    COSObject obj = bbox.at(i);
                    if (!obj.getType().isNumber()) {
                        LOGGER.log(Level.SEVERE, "Font bounding box array for font " + this.fontName + " contains " + (Object)((Object)obj.getType()));
                        return null;
                    }
                    res[i] = obj.getReal();
                }
                this.fontBoundingBox = res;
            } else {
                LOGGER.log(Level.SEVERE, "Font bounding box array for font " + this.fontName + " is not an array of 4 elements");
                return null;
            }
        }
        return this.fontBoundingBox;
    }

    public Double getItalicAngle() {
        if (this.italicAngle == null) {
            this.italicAngle = this.getRealKey(ASAtom.ITALIC_ANGLE);
        }
        return this.italicAngle != null ? this.italicAngle : 0.0;
    }

    public Double getAscent() {
        if (this.ascent == null) {
            this.ascent = this.getRealKey(ASAtom.ASCENT);
        }
        return this.ascent;
    }

    public Double getDescent() {
        if (this.descent == null) {
            this.descent = this.getRealKey(ASAtom.DESCENT);
        }
        return this.descent;
    }

    public Double getLeading() {
        if (this.leading == null) {
            Double res = this.getRealKey(ASAtom.LEADING);
            this.leading = res == null ? DEFAULT_LEADING : res;
        }
        return this.leading;
    }

    public Double getCapHeight() {
        if (this.capHeight == null) {
            this.capHeight = this.getRealKey(ASAtom.CAP_HEIGHT);
        }
        return this.capHeight;
    }

    public Double getXHeight() {
        if (this.xHeight == null) {
            Double res = this.getRealKey(ASAtom.XHEIGHT);
            this.xHeight = res == null ? DEFAULT_XHEIGHT : res;
        }
        return this.xHeight;
    }

    public Double getStemV() {
        if (this.stemV == null) {
            this.stemV = this.getRealKey(ASAtom.STEM_V);
        }
        return this.stemV;
    }

    public Double getStemH() {
        if (this.stemH == null) {
            Double res = this.getRealKey(ASAtom.STEM_H);
            this.stemH = res == null ? DEFAULT_STEM_H : res;
        }
        return this.stemH;
    }

    public Double getAvgWidth() {
        if (this.avgWidth == null) {
            Double res = this.getRealKey(ASAtom.AVG_WIDTH);
            this.avgWidth = res == null ? DEFAULT_WIDTH : res;
        }
        return this.avgWidth;
    }

    public Double getMaxWidth() {
        if (this.maxWidth == null) {
            Double res = this.getRealKey(ASAtom.MAX_WIDTH);
            this.maxWidth = res == null ? DEFAULT_WIDTH : res;
        }
        return this.maxWidth;
    }

    public Double getMissingWidth() {
        if (this.missingWidth == null) {
            Double res = this.getRealKey(ASAtom.MISSING_WIDTH);
            this.missingWidth = res == null ? DEFAULT_WIDTH : res;
        }
        return this.missingWidth;
    }

    public String getCharSet() {
        if (this.charSet == null) {
            this.charSet = this.getStringKey(ASAtom.CHAR_SET);
        }
        return this.charSet;
    }

    public COSStream getFontFile() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE);
    }

    public COSStream getFontFile2() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE2);
    }

    public COSStream getFontFile3() {
        return this.getCOSStreamWithCheck(ASAtom.FONT_FILE3);
    }

    public boolean canParseFontFile(ASAtom key) {
        return this.knownKey(key) && this.getCOSStreamWithCheck(key) != null;
    }

    private COSStream getCOSStreamWithCheck(ASAtom key) {
        COSObject res = this.getKey(key);
        if (res.getType() == COSObjType.COS_STREAM) {
            return (COSStream)res.getDirectBase();
        }
        return null;
    }

    public void setFontName(ASAtom fontName) {
        if (fontName != null) {
            this.fontName = fontName.getValue();
            this.setNameKey(ASAtom.FONT_NAME, fontName);
        }
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void setFontStretch(ASAtom fontStretch) {
        this.fontStretch = fontStretch;
    }

    public void setFontWeight(Double fontWeight) {
        this.fontWeight = fontWeight;
    }

    public void setFixedPitch(Boolean fixedPitch) {
        this.isFixedPitch = fixedPitch;
    }

    public void setSerif(Boolean serif) {
        this.isSerif = serif;
    }

    public void setSymbolic(Boolean symbolic) {
        this.isSymbolic = symbolic;
    }

    public void setScript(Boolean script) {
        this.isScript = script;
    }

    public void setNonSymblic(Boolean nonSymblic) {
        this.isNonSymblic = nonSymblic;
    }

    public void setItalic(Boolean italic) {
        this.isItalic = italic;
    }

    public void setAllCap(Boolean allCap) {
        this.isAllCap = allCap;
    }

    public void setSmallCup(Boolean smallCup) {
        this.isSmallCup = smallCup;
    }

    public void setForceBold(Boolean forceBold) {
        this.isForceBold = forceBold;
    }

    public void setFontBoundingBox(double[] fontBoundingBox) {
        this.fontBoundingBox = fontBoundingBox;
    }

    public void setItalicAngle(Double italicAngle) {
        this.italicAngle = italicAngle;
    }

    public void setAscent(Double ascent) {
        this.ascent = ascent;
    }

    public void setDescent(Double descent) {
        this.descent = descent;
    }

    public void setLeading(Double leading) {
        this.leading = leading;
    }

    public void setCapHeight(Double capHeight) {
        this.capHeight = capHeight;
    }

    public void setxHeight(Double xHeight) {
        this.xHeight = xHeight;
    }

    public void setStemV(Double stemV) {
        this.stemV = stemV;
    }

    public void setStemH(Double stemH) {
        this.stemH = stemH;
    }

    public void setAvgWidth(Double avgWidth) {
        this.avgWidth = avgWidth;
    }

    public void setMaxWidth(Double maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMissingWidth(Double missingWidth) {
        this.missingWidth = missingWidth;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public static PDFontDescriptor getDescriptorFromMetrics(StandardFontMetrics sfm) {
        PDFontDescriptor res = new PDFontDescriptor(null);
        boolean isSymbolic = "FontSpecific".equals(sfm.getEncodingScheme());
        res.fontName = sfm.getFontName();
        res.setFontName(ASAtom.getASAtom(sfm.getFontName()));
        res.fontFamily = sfm.getFamilyName();
        res.fontBoundingBox = sfm.getFontBBox();
        res.isSymbolic = isSymbolic;
        res.isNonSymblic = !isSymbolic;
        res.charSet = sfm.getCharSet();
        res.capHeight = sfm.getCapHeight();
        res.xHeight = sfm.getXHeight();
        res.descent = sfm.getDescend();
        res.ascent = sfm.getAscend();
        res.italicAngle = sfm.getItalicAngle();
        double totalWidth = 0.0;
        int glyphNum = 0;
        Iterator<Map.Entry<String, Integer>> widthsIterator = sfm.getWidthsIterator();
        while (widthsIterator.hasNext()) {
            Integer width = widthsIterator.next().getValue();
            if (width == null || width <= 0) continue;
            totalWidth += (double)width.intValue();
            ++glyphNum;
        }
        if (glyphNum != 0) {
            res.avgWidth = totalWidth / (double)glyphNum;
        }
        return res;
    }
}

