/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDNameSpaceRoleMapping;
import org.verapdf.tools.StaticResources;

public class PDStructureNameSpace
extends PDObject {
    private final PDNameSpaceRoleMapping nsRoleMap;

    private PDStructureNameSpace(COSObject obj) {
        super(obj);
        COSObject roleMap = this.getKey(ASAtom.ROLE_MAP_NS);
        this.nsRoleMap = roleMap != null && roleMap.getType() == COSObjType.COS_DICT ? new PDNameSpaceRoleMapping(roleMap) : null;
    }

    public String getNS() {
        COSObject obj = this.getKey(ASAtom.NS);
        if (obj != null && obj.getType() == COSObjType.COS_STRING) {
            return obj.getString();
        }
        return null;
    }

    public PDNameSpaceRoleMapping getNameSpaceMapping() {
        return this.nsRoleMap;
    }

    static PDStructureNameSpace createNameSpace(COSObject obj) {
        if (obj == null || obj.getType() != COSObjType.COS_DICT) {
            throw new IllegalArgumentException("COSObject argument should be dictionary type");
        }
        COSKey key = obj.getObjectKey();
        if (key == null) {
            throw new IllegalArgumentException("COSObject argument can not be direct");
        }
        PDStructureNameSpace res = StaticResources.getStructureNameSpace(key);
        if (res == null) {
            res = new PDStructureNameSpace(obj);
            StaticResources.cacheStructureNameSpace(res);
        }
        return res;
    }
}

