/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDStructureNameSpace;

public class StructureType {
    private final ASAtom type;
    private final PDStructureNameSpace nameSpace;

    private StructureType(ASAtom type, PDStructureNameSpace nameSpace) {
        this.type = type;
        this.nameSpace = nameSpace;
    }

    public static StructureType createStructureType(COSObject object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object can not be null");
        }
        COSObjType objType = object.getType();
        if (objType == COSObjType.COS_NAME) {
            return StructureType.createStructureType(object, null);
        }
        if (objType == COSObjType.COS_ARRAY && object.size() >= 2) {
            return StructureType.createStructureType(object.at(0), object.at(1));
        }
        return null;
    }

    public static StructureType createStructureType(COSObject type, COSObject ns) {
        if (type != null && type.getType() == COSObjType.COS_NAME) {
            if (ns != null && ns.getType() == COSObjType.COS_DICT) {
                return new StructureType(type.getName(), PDStructureNameSpace.createNameSpace(ns));
            }
            return new StructureType(type.getName(), null);
        }
        return null;
    }

    public static StructureType createStructureType(ASAtom type, PDStructureNameSpace nameSpace) {
        if (type != null) {
            return new StructureType(type, nameSpace);
        }
        return null;
    }

    public static StructureType createStructureType(ASAtom type) {
        if (type != null) {
            return new StructureType(type, null);
        }
        return null;
    }

    public ASAtom getType() {
        return this.type;
    }

    public String getNameSpaceURI() {
        return this.nameSpace == null ? "http://iso.org/pdf/ssn" : this.nameSpace.getNS();
    }

    public PDStructureNameSpace getNameSpace() {
        return this.nameSpace;
    }
}

