/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.his;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.his.XPMEventHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Herzinsuffizienz/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_MEDIKATION = 3;
    protected static final int cABSCHNITT_SCHULUNG = 4;
    protected static final int cABSCHNITT_BEHANDLUNGSPLANUNG = 5;
    protected static final int cABSCHNITT_RELEVANTEEREIGNISSE = 6;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cRELEVANTEEREIGNISSE = "Relevante Ereignisse";
    protected static final String cMEDIKATION = "Medikamente";
    protected static final String cSCHULUNG = "Schulung";
    protected static final String cBEHANDLUNGSPLANUNG = "Behandlungsplanung";
    protected static final String cEINSCHREIBUNGWEGEN = "Einschreibung erfolgte wegen";
    protected static final String cDATEPATTERN_JJJJ = "[0-9]{4}";
    protected static final String cDATEPATTERN_0000JJJJ = "[0-9]{4}-00-00";
    protected static final String cDATEPATTERN_00MMJJJJ = "[0-9]{4}-[0-9]{2}-00";
    protected static final String cDATEPATTERN_TTMMJJJJ = "[0-9]{4}-(0[1-9]|10|11|12)-(0[1-9]|1[0-9]|2[0-9]|3[0-1])";
    protected static final String cRAUCHER = "Raucher";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCKSYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCKDIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cBEGLEITERKRANKUNGEN = "Begleiterkrankungen";
    protected static final String cSYMPTOMATIK = "Symptomatik";
    protected static final String cSERUMELEKTROLYTE = "Serum-Elektrolyte und eGFR in den letzten sechs Monaten";
    protected static final String cSCHULUNGEMPFOHLEN = "Herzinsuffizienz-spezifische Schulung empfohlen (bei aktueller Dokumentation)";
    protected static final String cSCHULUNGBEREITSWAHRGENOMMEN = "Bereits vor Einschreibung in das DMP an einer Herzinsuffizienz-spezifischen Schulung teilgenommen";
    protected static final String cSCHULUNGWAHRGENOMMEN = "Empfohlene Herzinsuffizienz-spezifische Schulung wahrgenommen";
    protected static final String cUNGEPLANTESTATIONAEREBEHANDLUNG = "Ungeplante station\u00e4re Behandlung, wegen Herzinsuffizienz, seit der letzten Dokumentation";
    protected static String m_sDokumentTyp = null;
    protected static double m_dKoerpergroesse = 0.0;
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static int m_nRaucher = 0;
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nSymptomatik = 0;
    protected static int m_nSerumElektrolyte = 0;
    protected static int m_nUngeplantStationaer = 0;
    protected static boolean m_bUngeplantStationaer = false;
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nACEHemmer = 0;
    protected static int m_nACEHemmerEvi = 0;
    protected static int m_nBetaBlocker = 0;
    protected static int m_nBetaBlockerEvi = 0;
    protected static int m_nMineralKortikoid = 0;
    protected static int m_nMineralKortikoidEvi = 0;
    protected static int m_nSglt2Inhibitor = 0;
    protected static int m_nSchulung = 0;
    protected static int m_nSchulungDavor = 0;
    protected static int m_nSchulungWahrgenommen = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nDokumentationsintervall = 0;
    protected static int m_nTraining = 0;
    protected static int m_nGewichtsprotokoll = 0;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public boolean juengerAls(Date date1, Date date2) throws Exception {
        try {
            return date2 == null || date1 != null && date2 != null && date1.after(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (juengerAls)");
            return false;
        }
    }

    public boolean gleichAlt(Date date1, Date date2) throws Exception {
        try {
            return date1 != null && date2 != null && date1.equals(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (gleichAlt)");
            return false;
        }
    }

    public boolean kleinerOderGleich(Date date1, Date date2) throws Exception {
        try {
            return date1.equals(date2) || date1.before(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (kleinerOderGleich)");
            return false;
        }
    }

    public String normalizeDate(String date) throws Exception {
        try {
            if (date.matches(cDATEPATTERN_JJJJ)) {
                return date.substring(0, 4) + "-01-01";
            }
            if (date.matches(cDATEPATTERN_0000JJJJ)) {
                return date.substring(0, 5) + "01-01";
            }
            if (date.matches(cDATEPATTERN_00MMJJJJ)) {
                return date.substring(0, 8) + "01";
            }
            if (date.matches(cDATEPATTERN_TTMMJJJJ)) {
                return date;
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (normalizeDate)");
            return null;
        }
    }

    public Date getDatum(String sValue, String sFeld) throws Exception {
        try {
            Date dateReturn = new Date();
            m_SciphoxFormat.setLenient(true);
            try {
                dateReturn = m_SciphoxFormat.parse(sValue);
            }
            catch (ParseException ex) {
                dateReturn = null;
            }
            m_SciphoxFormat.setLenient(false);
            return dateReturn;
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (getDatum)");
            return null;
        }
    }

    public Date getDatumNormalized(String sValue, String sFeld) throws Exception {
        try {
            return this.getDatum(this.normalizeDate(sValue), sFeld);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (getDatumNormalized)");
            return null;
        }
    }

    public void pruefeEDFD() throws Exception {
        FehlerListe.newGroup(cADMINISTRATIVEDATEN);
        this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen);
        if (m_nEinschreibungWegen == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Einschreibung wegen");
        }
        if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
            m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
        }
        if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
            m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
        }
        if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
            m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
        }
        if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
            m_MeldungPool.addMeldung("DMP-071");
        }
        if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
            m_MeldungPool.addMeldung("DMP-112");
        }
        if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
            m_MeldungPool.addMeldung("DMP-113");
        }
        m_MeldungPool.reportMeldungen();
        FehlerListe.newGroup(cANAMNESE);
        if (!m_bKoerpergroesse) {
            m_MeldungPool.addMeldung("DMP-002", cKOERPERGROESSE);
        }
        if (m_dKoerpergroesse < 0.0 || m_dKoerpergroesse > 2.5) {
            m_MeldungPool.addMeldung("DMP-021");
        }
        if (!m_bKoerpergewicht) {
            m_MeldungPool.addMeldung("DMP-002", cKOERPERGEWICHT);
        }
        if (m_nKoerpergewicht < 0 || m_nKoerpergewicht > 300) {
            m_MeldungPool.addMeldung("DMP-023");
        }
        if (m_nRaucher == 0 && m_nPatientenAlter >= 12) {
            m_MeldungPool.addMeldung("DMP-002", cRAUCHER);
        }
        if (this.countBits(m_nRaucher) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cRAUCHER);
        }
        if (m_bBlutdruckSystolisch != m_bBlutdruckDiastolisch) {
            m_MeldungPool.addMeldung("DMP-045");
        }
        if (!m_bBlutdruckSystolisch) {
            m_MeldungPool.addMeldung("DMP-002", cBLUTDRUCKSYSTOLISCH);
        }
        if (m_bBlutdruckSystolisch && (m_nBlutdruckSystolisch < 50 || m_nBlutdruckSystolisch > 300)) {
            m_MeldungPool.addMeldung("DMP-014");
        }
        if (m_bBlutdruckDiastolisch && (m_nBlutdruckDiastolisch < 30 || m_nBlutdruckDiastolisch > 180)) {
            m_MeldungPool.addMeldung("DMP-017");
        }
        if (m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch && m_nBlutdruckSystolisch <= m_nBlutdruckDiastolisch) {
            m_MeldungPool.addMeldung("DMP-016");
        }
        if (!m_bBlutdruckDiastolisch) {
            m_MeldungPool.addMeldung("DMP-002", cBLUTDRUCKDIASTOLISCH);
        }
        if (m_nBegleiterkrankungen == 0) {
            m_MeldungPool.addMeldung("DMP-002", cBEGLEITERKRANKUNGEN);
        }
        if (this.testBit(m_nBegleiterkrankungen, 65536) && this.countBits(m_nBegleiterkrankungen) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Keine der genannten Erkrankungen", cBEGLEITERKRANKUNGEN);
        }
        if (this.testBit(m_nEinschreibungWegen, 512)) {
            if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                m_MeldungPool.addMeldung("DMP-110");
            }
            if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                m_MeldungPool.addMeldung("DMP-111");
            }
        }
        if (this.countBits(m_nSymptomatik) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cSYMPTOMATIK);
        }
        if (this.countBits(m_nSymptomatik) == 0) {
            m_MeldungPool.addMeldung("DMP-002", cSYMPTOMATIK);
        }
        if (this.countBits(m_nSerumElektrolyte) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cSERUMELEKTROLYTE);
        }
        if (this.countBits(m_nSerumElektrolyte) == 0) {
            m_MeldungPool.addMeldung("DMP-002", cSERUMELEKTROLYTE);
        }
        m_MeldungPool.reportMeldungen();
        FehlerListe.newGroup(cRELEVANTEEREIGNISSE);
        if (!m_bFolgeDoku) {
            if (m_bUngeplantStationaer) {
                m_MeldungPool.addMeldung("HIS-043", cUNGEPLANTESTATIONAEREBEHANDLUNG, "Folgedokumentation");
            }
        } else {
            if (!m_bUngeplantStationaer) {
                m_MeldungPool.addMeldung("DMP-002", cUNGEPLANTESTATIONAEREBEHANDLUNG);
            }
            if (m_nUngeplantStationaer > 99) {
                m_MeldungPool.addMeldung("HIS-086", cUNGEPLANTESTATIONAEREBEHANDLUNG);
            }
        }
        m_MeldungPool.reportMeldungen();
        FehlerListe.newGroup(cMEDIKATION);
        if (m_nACEHemmer == 0) {
            m_MeldungPool.addMeldung("DMP-002", "ACE-Hemmer");
        }
        if (this.testBit(m_nACEHemmer, 1) && this.countBits(m_nACEHemmer) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "ACE-Hemmer");
        }
        if ((this.testBit(m_nACEHemmer, 1) || this.testBit(m_nACEHemmer, 8)) && m_nACEHemmerEvi == 0) {
            m_MeldungPool.addMeldung("DMP-002", "ACE-Hemmer/Evidenzbasierte Zieldosis");
        }
        if (!this.testBit(m_nACEHemmer, 1) && !this.testBit(m_nACEHemmer, 8) && m_nACEHemmerEvi != 0) {
            m_MeldungPool.addMeldung("HIS-085", "ACE-Hemmer/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nACEHemmerEvi, 1) && this.countBits(m_nACEHemmerEvi) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Erreicht", "ACE-Hemmer/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nACEHemmerEvi, 4) && this.testBit(m_nACEHemmerEvi, 8)) {
            m_MeldungPool.addMeldung("HIS-018", "ACE-Hemmer/Evidenzbasierte Zieldosis");
        }
        if (m_nBetaBlocker == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Betablocker");
        }
        if (this.testBit(m_nBetaBlocker, 1) && this.countBits(m_nBetaBlocker) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "Betablocker");
        }
        if (this.testBit(m_nBetaBlocker, 1) && m_nBetaBlockerEvi == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Betablocker/Evidenzbasierte Zieldosis");
        }
        if (!this.testBit(m_nBetaBlocker, 1) && m_nBetaBlockerEvi != 0) {
            m_MeldungPool.addMeldung("HIS-085", "Betablocker/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nBetaBlockerEvi, 1) && this.countBits(m_nBetaBlockerEvi) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Erreicht", "Betablocker/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nBetaBlockerEvi, 4) && this.testBit(m_nBetaBlockerEvi, 8)) {
            m_MeldungPool.addMeldung("HIS-018", "Betablocker/Evidenzbasierte Zieldosis");
        }
        if (m_nMineralKortikoid == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Mineralokortikoid-Rezeptor-Antagonist (MRA)");
        }
        if (this.testBit(m_nMineralKortikoid, 1) && this.countBits(m_nMineralKortikoid) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "Mineralokortikoid-Rezeptor-Antagonist (MRA)");
        }
        if (this.testBit(m_nMineralKortikoid, 1) && m_nMineralKortikoidEvi == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Mineralokortikoid-Rezeptor-Antagonist (MRA)/Evidenzbasierte Zieldosis");
        }
        if (!this.testBit(m_nMineralKortikoid, 1) && m_nMineralKortikoidEvi != 0) {
            m_MeldungPool.addMeldung("HIS-085", "Mineralokortikoid-Rezeptor-Antagonist (MRA)/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nMineralKortikoidEvi, 1) && this.countBits(m_nMineralKortikoidEvi) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Erreicht", "Mineralokortikoid-Rezeptor-Antagonist (MRA)/Evidenzbasierte Zieldosis");
        }
        if (this.testBit(m_nMineralKortikoidEvi, 4) && this.testBit(m_nMineralKortikoidEvi, 8)) {
            m_MeldungPool.addMeldung("HIS-018", "Mineralokortikoid-Rezeptor-Antagonist (MRA)/Evidenzbasierte Zieldosis");
        }
        if (m_nSglt2Inhibitor == 0) {
            m_MeldungPool.addMeldung("DMP-002", "SGLT2-Inhibitor");
        }
        if (this.testBit(m_nSglt2Inhibitor, 1) && this.countBits(m_nSglt2Inhibitor) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "SGLT2-Inhibitor");
        }
        m_MeldungPool.reportMeldungen();
        FehlerListe.newGroup(cSCHULUNG);
        if (m_nSchulung == 0) {
            m_MeldungPool.addMeldung("DMP-002", cSCHULUNGEMPFOHLEN);
        }
        if (this.countBits(m_nSchulung) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cSCHULUNGEMPFOHLEN);
        }
        if (!m_bFolgeDoku && m_nSchulungDavor == 0) {
            m_MeldungPool.addMeldung("DMP-002", cSCHULUNGBEREITSWAHRGENOMMEN);
        }
        if (m_bFolgeDoku && m_nSchulungDavor != 0) {
            m_MeldungPool.addMeldung("HIS-043", cSCHULUNGBEREITSWAHRGENOMMEN, "Folgedokumentation");
        }
        if (this.countBits(m_nSchulungDavor) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cSCHULUNGBEREITSWAHRGENOMMEN);
        }
        if (m_bFolgeDoku && m_nSchulungWahrgenommen == 0) {
            m_MeldungPool.addMeldung("DMP-002", cSCHULUNGWAHRGENOMMEN);
        }
        if (!m_bFolgeDoku && m_nSchulungWahrgenommen != 0) {
            m_MeldungPool.addMeldung("HIS-043", cSCHULUNGWAHRGENOMMEN);
        }
        if (this.countBits(m_nSchulungWahrgenommen) > 1) {
            m_MeldungPool.addMeldung("DMP-012", cSCHULUNGWAHRGENOMMEN);
        }
        m_MeldungPool.reportMeldungen();
        FehlerListe.newGroup(cBEHANDLUNGSPLANUNG);
        if ((this.testBit(m_nSymptomatik, 1) || this.testBit(m_nSymptomatik, 2) || this.testBit(m_nSymptomatik, 4)) && m_nTraining == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Regelm\u00e4\u00dfiges k\u00f6rperliches Training");
        }
        if (this.testBit(m_nTraining, 1) && this.countBits(m_nTraining) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "Regelm\u00e4\u00dfiges k\u00f6rperliches Training");
        }
        if (m_nDokumentationsintervall == 0) {
            m_MeldungPool.addMeldung("DMP-002", "Dokumentationsintervall");
        }
        if (this.countBits(m_nDokumentationsintervall) > 1) {
            m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
        }
        if (m_nGewichtsprotokoll == 0) {
            m_MeldungPool.addMeldung("DMP-002", "F\u00fchren eines Gewichtsprotokolls");
        }
        if (this.testBit(m_nGewichtsprotokoll, 1) && this.countBits(m_nGewichtsprotokoll) > 1) {
            m_MeldungPool.addMeldung("HIS-017", "Ja", "F\u00fchren eines Gewichtsprotokolls");
        }
        m_MeldungPool.reportMeldungen();
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Dokumenttyp");
            Object erwarteterDokumentTyp = null;
            String erwarteteDokumentation = null;
            if (!m_bFolgeDoku) {
                erwarteteDokumentation = "Erstdokumentation";
                erwarteterDokumentTyp = "EDMP_HI_EE";
            } else {
                erwarteteDokumentation = "Folgedokumentation";
                erwarteterDokumentTyp = "EDMP_HI_EV";
            }
            if (m_bAnlageA) {
                erwarteterDokumentTyp = (String)erwarteterDokumentTyp + "_A";
            }
            if (m_sDokumentTyp != null && !m_sDokumentTyp.equals(erwarteterDokumentTyp)) {
                m_MeldungPool.addMeldung("DMP-090", m_sDokumentTyp, erwarteteDokumentation, (String)erwarteterDokumentTyp);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bAnlageA) {
                    m_sFileName.append("_a.EVHI");
                } else {
                    m_sFileName.append(".EVHI");
                }
            } else if (m_bAnlageA) {
                m_sFileName.append("_a.EEHI");
            } else {
                m_sFileName.append(".EEHI");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bAnlageA ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVHI" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVHI") : (m_bAnlageA ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EEHI" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EEHI");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("HIS-039", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+HI_103\\.zip)")) {
                m_MeldungPool.addMeldung("HIS-079F", "HI_103.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeEDFD();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_sGeschlecht_ = "";
        m_sDokumentTyp = null;
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_dKoerpergroesse = 0.0;
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_nRaucher = 0;
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_nBegleiterkrankungen = 0;
        m_nSymptomatik = 0;
        m_nSerumElektrolyte = 0;
        m_nUngeplantStationaer = 0;
        m_bUngeplantStationaer = false;
        m_nEinschreibungWegen = 0;
        m_nACEHemmer = 0;
        m_nACEHemmerEvi = 0;
        m_nBetaBlocker = 0;
        m_nBetaBlockerEvi = 0;
        m_nMineralKortikoid = 0;
        m_nMineralKortikoidEvi = 0;
        m_nSglt2Inhibitor = 0;
        m_nSchulung = 0;
        m_nSchulungDavor = 0;
        m_nSchulungWahrgenommen = 0;
        m_nInformationsangebote = 0;
        m_nDokumentationsintervall = 0;
        m_nTraining = 0;
        m_nGewichtsprotokoll = 0;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

