/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.ruecken;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.ruecken.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Chronischer_Rueckenschmerz/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_EREIGNISSE = 4;
    protected static final int cABSCHNITT_MEDIKATION = 5;
    protected static final int cABSCHNITT_SCHULUNGEN = 6;
    protected static final int cABSCHNITT_SONSTIGEBEHANDLUNG = 7;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 8;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cEREIGNISSE = "Relevante Ereignisse";
    protected static final String cMEDIKATION = "Medikamente";
    protected static final String cSCHULUNGEN = "Schulung";
    protected static final String cSONSTIGEBEHANDLUNG = "Sonstige Behandlung";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cCPGITEM3 = "CPG Item 3: Durchschnittliche St\u00e4rke der Kreuzschmerzen in den letzten drei Monaten (0 = \"Keine\" bis 10 = \"St\u00e4rkster Schmerz\")";
    protected static final String cCPGITEM5 = "CPG Item 5: Kreuzschmerzbedingte Beeintr\u00e4chtigung der allt\u00e4glichen Aktivit\u00e4ten (Ankleiden, Waschen, Essen, Einkaufen etc.) in den letzten drei Monaten (0 = \"Keine\" bis 10 = \"Maximale Beeintr\u00e4chtigung\")";
    protected static final String cAMBULANTSTATIONAEREBEHANDLUNGEN = "Ungeplante ambulante oder station\u00e4re kreuzschmerzbedingte Akutbehandlung seit der letzten Dokumentation";
    protected static final String cZIELERREICHUNG = "Erreichung mindestens eines der individuell vereinbarten Ziele seit der letzten Dokumentation";
    protected static final String cBEENDIGUNG = "Beendigung der DMP-Teilnahme vereinbart";
    protected static boolean m_bDiagnoseBekanntSeit = false;
    protected static int m_nDiagnoseBekanntSeit = 0;
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nModulTeilnahme = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static boolean m_bAmbulantStationaereBehandlungen = false;
    protected static int m_nAmbulantStationaereBehandlungen = 0;
    protected static int m_nOpiodanalgetika = 0;
    protected static int m_nNichtOpiodanalgetika = 0;
    protected static int m_nSchulungVorDMPWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nSchulungWahrgenommen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nKoerperlicheAktivitaet = 0;
    protected static int m_nZielErreichung = 0;
    protected static boolean m_bCPGItem3 = false;
    protected static String m_sCPGItem3 = new String();
    protected static int m_nCPGItem3 = 0;
    protected static boolean m_bCPGItem5 = false;
    protected static String m_sCPGItem5 = new String();
    protected static int m_nCPGItem5 = 0;
    protected static int m_nBeendigungDMPTeilnahme = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nIntervall = 0;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen, m_sFileName.toString());
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("R\u00dcCKENSCHMERZ", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M")) {
                    if (m_nPatientenAlter < 60) {
                        m_MeldungPool.addMeldung("DMP-107");
                    }
                } else if (m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-108");
                }
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 2) && !this.testBit(m_nEinschreibungWegen, 4) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-070");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 1) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-072");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 64) || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-073");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cEREIGNISSE);
            if (m_bFolgeDoku) {
                if (!m_bAmbulantStationaereBehandlungen) {
                    m_MeldungPool.addMeldung("DMP-002", "'Ungeplante ambulante oder station\u00e4re kreuzschmerzbedingte Akutbehandlung seit der letzten Dokumentation'");
                }
                if (m_bAmbulantStationaereBehandlungen && (m_nAmbulantStationaereBehandlungen < 0 || m_nAmbulantStationaereBehandlungen > 99)) {
                    m_MeldungPool.addMeldung("DMP-055", cAMBULANTSTATIONAEREBEHANDLUNGEN, "0", "99");
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cMEDIKATION);
            if (m_nOpiodanalgetika == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle kreuzschmerzbedingte Schmerzmedikation: Opioidanalgetika'");
            }
            if (this.countBits(m_nOpiodanalgetika) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Aktuelle kreuzschmerzbedingte Schmerzmedikation: Opioidanalgetika'");
            }
            if (m_nNichtOpiodanalgetika == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle kreuzschmerzbedingte Schmerzmedikation: Nicht-Opioidanalgetika'");
            }
            if (this.countBits(m_nNichtOpiodanalgetika) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Aktuelle kreuzschmerzbedingte Schmerzmedikation: Nicht-Opioidanalgetika'");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (!m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Bereits vor Einschreibung in das DMP an einer multimodalen Schulung teilgenommen'");
            }
            if (this.countBits(m_nSchulungVorDMPWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Bereits vor Einschreibung in das DMP an einer multimodalen Schulung teilgenommen'");
            }
            if (m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", "Bereits vor Einschreibung in das DMP an einer multimodalen Schulung teilgenommen", "Folgedokumentation");
            }
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Kreuzschmerz-spezifische Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (this.countBits(m_nSchulungEmpfohlen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Kreuzschmerz-spezifische Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (m_bFolgeDoku && m_nSchulungWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Kreuzschmerz-spezifische Schulung wahrgenommen'");
            }
            if (this.countBits(m_nSchulungWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Kreuzschmerz-spezifische Schulung wahrgenommen");
            }
            if (!m_bFolgeDoku && m_nSchulungWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", "Kreuzschmerz-spezifische Schulung wahrgenommen", "Erstdokumentation");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSONSTIGEBEHANDLUNG);
            if (m_nKoerperlicheAktivitaet == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Regelm\u00e4\u00dfig k\u00f6rperlich aktiv'");
            }
            if (this.countBits(m_nKoerperlicheAktivitaet) > 1 && this.testBit(m_nKoerperlicheAktivitaet, 1)) {
                m_MeldungPool.addMeldung("DMP-105", "Regelm\u00e4\u00dfig k\u00f6rperlich aktiv");
            }
            if (m_bFolgeDoku && m_nZielErreichung == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Erreichung mindestens eines der individuell vereinbarten Ziele seit der letzten Dokumentation'");
            }
            if (!m_bFolgeDoku && m_nZielErreichung != 0) {
                m_MeldungPool.addMeldung("DMP-090", cZIELERREICHUNG, "Erstdokumentation");
            }
            if (this.countBits(m_nZielErreichung) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cZIELERREICHUNG);
            }
            if (!m_bCPGItem3) {
                m_MeldungPool.addMeldung("DMP-002", "'CPG Item 3: Durchschnittliche St\u00e4rke der Kreuzschmerzen in den letzten drei Monaten (0 = \"Keine\" bis 10 = \"St\u00e4rkster Schmerz\")'");
            } else if (m_nCPGItem3 < 0 || m_nCPGItem3 > 10) {
                m_MeldungPool.addMeldung("DMP-104", cCPGITEM3);
            }
            if (!m_bCPGItem5) {
                m_MeldungPool.addMeldung("DMP-002", "'CPG Item 5: Kreuzschmerzbedingte Beeintr\u00e4chtigung der allt\u00e4glichen Aktivit\u00e4ten (Ankleiden, Waschen, Essen, Einkaufen etc.) in den letzten drei Monaten (0 = \"Keine\" bis 10 = \"Maximale Beeintr\u00e4chtigung\")'");
            } else if (m_nCPGItem5 < 0 || m_nCPGItem5 > 10) {
                m_MeldungPool.addMeldung("DMP-104", cCPGITEM5);
            }
            if (m_bFolgeDoku && m_nBeendigungDMPTeilnahme == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Beendigung der DMP-Teilnahme vereinbart'");
            }
            if (this.countBits(m_nBeendigungDMPTeilnahme) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Beendigung der DMP-Teilnahme vereinbart'");
            }
            if (!m_bFolgeDoku && m_nBeendigungDMPTeilnahme != 0) {
                m_MeldungPool.addMeldung("DMP-090", cBEENDIGUNG, "Erstdokumentation");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVCR");
                } else {
                    m_sFileName.append(".EVCR");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EECR");
            } else {
                m_sFileName.append(".EECR");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVCR" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVCR") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EECR" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EECR");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+CR_101\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "CR_101.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_bDiagnoseBekanntSeit = false;
        m_nDiagnoseBekanntSeit = 0;
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nModulTeilnahme = 0;
        m_nEinschreibungWegen = 0;
        m_bAmbulantStationaereBehandlungen = false;
        m_nAmbulantStationaereBehandlungen = 0;
        m_nOpiodanalgetika = 0;
        m_nNichtOpiodanalgetika = 0;
        m_nSchulungVorDMPWahrgenommen = 0;
        m_nSchulungEmpfohlen = 0;
        m_nSchulungWahrgenommen = 0;
        m_nBegleiterkrankungen = 0;
        m_nKoerperlicheAktivitaet = 0;
        m_nZielErreichung = 0;
        m_bCPGItem3 = false;
        m_sCPGItem3 = new String();
        m_nCPGItem3 = 0;
        m_bCPGItem5 = false;
        m_sCPGItem5 = new String();
        m_nCPGItem5 = 0;
        m_nBeendigungDMPTeilnahme = 0;
        m_nInformationsangebote = 0;
        m_nIntervall = 0;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

